package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{ServicePrincipal, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobWorkerExecutorConfiguration(
    pollingAccounts: Option[Iterable[AccountId]] = None,
    pollingServicePrincipals: Option[Iterable[ServicePrincipal]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.JobWorkerExecutorConfiguration = {
    import JobWorkerExecutorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.JobWorkerExecutorConfiguration
      .builder()
      .optionallyWith(
        pollingAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.pollingAccounts)
      .optionallyWith(
        pollingServicePrincipals.map(value =>
          value.map { item =>
            ServicePrincipal.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.pollingServicePrincipals)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly =
    zio.aws.codepipeline.model.JobWorkerExecutorConfiguration
      .wrap(buildAwsValue())
}
object JobWorkerExecutorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.JobWorkerExecutorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.JobWorkerExecutorConfiguration =
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration(
        pollingAccounts.map(value => value),
        pollingServicePrincipals.map(value => value)
      )
    def pollingAccounts: Option[List[AccountId]]
    def pollingServicePrincipals: Option[List[ServicePrincipal]]
    def getPollingAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("pollingAccounts", pollingAccounts)
    def getPollingServicePrincipals
        : ZIO[Any, AwsError, List[ServicePrincipal]] = AwsError
      .unwrapOptionField("pollingServicePrincipals", pollingServicePrincipals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.JobWorkerExecutorConfiguration
  ) extends zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly {
    override val pollingAccounts: Option[List[AccountId]] = scala
      .Option(impl.pollingAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.primitives.AccountId(item)
        }.toList
      )
    override val pollingServicePrincipals: Option[List[ServicePrincipal]] =
      scala
        .Option(impl.pollingServicePrincipals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.ServicePrincipal(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.JobWorkerExecutorConfiguration
  ): zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly =
    new Wrapper(impl)
}
