package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ActionConfigurationValue,
  ActionConfigurationKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActionConfiguration(
    configuration: Option[
      Map[ActionConfigurationKey, ActionConfigurationValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionConfiguration = {
    import ActionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionConfiguration
      .builder()
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (ActionConfigurationKey
                .unwrap(key): java.lang.String) -> (ActionConfigurationValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionConfiguration.ReadOnly =
    zio.aws.codepipeline.model.ActionConfiguration.wrap(buildAwsValue())
}
object ActionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionConfiguration =
      zio.aws.codepipeline.model
        .ActionConfiguration(configuration.map(value => value))
    def configuration
        : Option[Map[ActionConfigurationKey, ActionConfigurationValue]]
    def getConfiguration: ZIO[Any, AwsError, Map[
      ActionConfigurationKey,
      ActionConfigurationValue
    ]] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionConfiguration
  ) extends zio.aws.codepipeline.model.ActionConfiguration.ReadOnly {
    override val configuration
        : Option[Map[ActionConfigurationKey, ActionConfigurationValue]] = scala
      .Option(impl.configuration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codepipeline.model.primitives.ActionConfigurationKey(
              key
            ) -> zio.aws.codepipeline.model.primitives
              .ActionConfigurationValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionConfiguration
  ): zio.aws.codepipeline.model.ActionConfiguration.ReadOnly = new Wrapper(impl)
}
