package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StageName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StageState(
    stageName: Option[StageName] = None,
    inboundExecution: Option[zio.aws.codepipeline.model.StageExecution] = None,
    inboundTransitionState: Option[zio.aws.codepipeline.model.TransitionState] =
      None,
    actionStates: Option[Iterable[zio.aws.codepipeline.model.ActionState]] =
      None,
    latestExecution: Option[zio.aws.codepipeline.model.StageExecution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageState = {
    import StageState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageState
      .builder()
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(inboundExecution.map(value => value.buildAwsValue()))(
        _.inboundExecution
      )
      .optionallyWith(
        inboundTransitionState.map(value => value.buildAwsValue())
      )(_.inboundTransitionState)
      .optionallyWith(
        actionStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionStates)
      .optionallyWith(latestExecution.map(value => value.buildAwsValue()))(
        _.latestExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageState.ReadOnly =
    zio.aws.codepipeline.model.StageState.wrap(buildAwsValue())
}
object StageState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageState =
      zio.aws.codepipeline.model.StageState(
        stageName.map(value => value),
        inboundExecution.map(value => value.asEditable),
        inboundTransitionState.map(value => value.asEditable),
        actionStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        latestExecution.map(value => value.asEditable)
      )
    def stageName: Option[StageName]
    def inboundExecution
        : Option[zio.aws.codepipeline.model.StageExecution.ReadOnly]
    def inboundTransitionState
        : Option[zio.aws.codepipeline.model.TransitionState.ReadOnly]
    def actionStates
        : Option[List[zio.aws.codepipeline.model.ActionState.ReadOnly]]
    def latestExecution
        : Option[zio.aws.codepipeline.model.StageExecution.ReadOnly]
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getInboundExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageExecution.ReadOnly
    ] = AwsError.unwrapOptionField("inboundExecution", inboundExecution)
    def getInboundTransitionState: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.TransitionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inboundTransitionState",
      inboundTransitionState
    )
    def getActionStates: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ActionState.ReadOnly
    ]] = AwsError.unwrapOptionField("actionStates", actionStates)
    def getLatestExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageExecution.ReadOnly
    ] = AwsError.unwrapOptionField("latestExecution", latestExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageState
  ) extends zio.aws.codepipeline.model.StageState.ReadOnly {
    override val stageName: Option[StageName] = scala
      .Option(impl.stageName())
      .map(value => zio.aws.codepipeline.model.primitives.StageName(value))
    override val inboundExecution
        : Option[zio.aws.codepipeline.model.StageExecution.ReadOnly] = scala
      .Option(impl.inboundExecution())
      .map(value => zio.aws.codepipeline.model.StageExecution.wrap(value))
    override val inboundTransitionState
        : Option[zio.aws.codepipeline.model.TransitionState.ReadOnly] = scala
      .Option(impl.inboundTransitionState())
      .map(value => zio.aws.codepipeline.model.TransitionState.wrap(value))
    override val actionStates
        : Option[List[zio.aws.codepipeline.model.ActionState.ReadOnly]] = scala
      .Option(impl.actionStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.ActionState.wrap(item)
        }.toList
      )
    override val latestExecution
        : Option[zio.aws.codepipeline.model.StageExecution.ReadOnly] = scala
      .Option(impl.latestExecution())
      .map(value => zio.aws.codepipeline.model.StageExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageState
  ): zio.aws.codepipeline.model.StageState.ReadOnly = new Wrapper(impl)
}
