package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Version, ActionProvider}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ActionTypeId(
    category: zio.aws.codepipeline.model.ActionCategory,
    owner: zio.aws.codepipeline.model.ActionOwner,
    provider: ActionProvider,
    version: Version
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeId = {
    import ActionTypeId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeId
      .builder()
      .category(category.unwrap)
      .owner(owner.unwrap)
      .provider(ActionProvider.unwrap(provider): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeId.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeId.wrap(buildAwsValue())
}
object ActionTypeId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeId =
      zio.aws.codepipeline.model.ActionTypeId(
        category,
        owner,
        provider,
        version
      )
    def category: zio.aws.codepipeline.model.ActionCategory
    def owner: zio.aws.codepipeline.model.ActionOwner
    def provider: ActionProvider
    def version: Version
    def getCategory
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionCategory] =
      ZIO.succeed(category)
    def getOwner: ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionOwner] =
      ZIO.succeed(owner)
    def getProvider: ZIO[Any, Nothing, ActionProvider] = ZIO.succeed(provider)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeId
  ) extends zio.aws.codepipeline.model.ActionTypeId.ReadOnly {
    override val category: zio.aws.codepipeline.model.ActionCategory =
      zio.aws.codepipeline.model.ActionCategory.wrap(impl.category())
    override val owner: zio.aws.codepipeline.model.ActionOwner =
      zio.aws.codepipeline.model.ActionOwner.wrap(impl.owner())
    override val provider: ActionProvider =
      zio.aws.codepipeline.model.primitives.ActionProvider(impl.provider())
    override val version: Version =
      zio.aws.codepipeline.model.primitives.Version(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeId
  ): zio.aws.codepipeline.model.ActionTypeId.ReadOnly = new Wrapper(impl)
}
