package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PollForJobsResponse(
    jobs: Option[Iterable[zio.aws.codepipeline.model.Job]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse = {
    import PollForJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly =
    zio.aws.codepipeline.model.PollForJobsResponse.wrap(buildAwsValue())
}
object PollForJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PollForJobsResponse =
      zio.aws.codepipeline.model.PollForJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobs: Option[List[zio.aws.codepipeline.model.Job.ReadOnly]]
    def getJobs
        : ZIO[Any, AwsError, List[zio.aws.codepipeline.model.Job.ReadOnly]] =
      AwsError.unwrapOptionField("jobs", jobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse
  ) extends zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly {
    override val jobs: Option[List[zio.aws.codepipeline.model.Job.ReadOnly]] =
      scala
        .Option(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Job.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse
  ): zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly = new Wrapper(impl)
}
