package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListActionTypesResponse(
    actionTypes: Iterable[zio.aws.codepipeline.model.ActionType],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse = {
    import ListActionTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse
      .builder()
      .actionTypes(actionTypes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly =
    zio.aws.codepipeline.model.ListActionTypesResponse.wrap(buildAwsValue())
}
object ListActionTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListActionTypesResponse =
      zio.aws.codepipeline.model.ListActionTypesResponse(
        actionTypes.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def actionTypes: List[zio.aws.codepipeline.model.ActionType.ReadOnly]
    def nextToken: Option[NextToken]
    def getActionTypes: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.ActionType.ReadOnly
    ]] = ZIO.succeed(actionTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse
  ) extends zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly {
    override val actionTypes
        : List[zio.aws.codepipeline.model.ActionType.ReadOnly] = impl
      .actionTypes()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.ActionType.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse
  ): zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly = new Wrapper(
    impl
  )
}
