package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Timestamp, PipelineArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PipelineMetadata(
    pipelineArn: Option[PipelineArn] = None,
    created: Option[Timestamp] = None,
    updated: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineMetadata = {
    import PipelineMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(updated.map(value => Timestamp.unwrap(value): Instant))(
        _.updated
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineMetadata.ReadOnly =
    zio.aws.codepipeline.model.PipelineMetadata.wrap(buildAwsValue())
}
object PipelineMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineMetadata =
      zio.aws.codepipeline.model.PipelineMetadata(
        pipelineArn.map(value => value),
        created.map(value => value),
        updated.map(value => value)
      )
    def pipelineArn: Option[PipelineArn]
    def created: Option[Timestamp]
    def updated: Option[Timestamp]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updated", updated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
  ) extends zio.aws.codepipeline.model.PipelineMetadata.ReadOnly {
    override val pipelineArn: Option[PipelineArn] = scala
      .Option(impl.pipelineArn())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineArn(value))
    override val created: Option[Timestamp] = scala
      .Option(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val updated: Option[Timestamp] = scala
      .Option(impl.updated())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
  ): zio.aws.codepipeline.model.PipelineMetadata.ReadOnly = new Wrapper(impl)
}
