package zio.aws.codepipeline
import zio.aws.codepipeline.model.GetPipelineExecutionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.codepipeline.paginators.{
  ListPipelineExecutionsPublisher,
  ListPipelinesPublisher,
  ListActionTypesPublisher,
  ListTagsForResourcePublisher,
  ListActionExecutionsPublisher
}
import software.amazon.awssdk.services.codepipeline.model.{
  AcknowledgeJobResponse,
  AcknowledgeThirdPartyJobResponse,
  PollForJobsRequest,
  PollForThirdPartyJobsRequest,
  PutActionRevisionResponse,
  StopPipelineExecutionResponse,
  GetPipelineExecutionResponse,
  PutJobFailureResultRequest,
  ActionType,
  DeleteCustomActionTypeRequest,
  RetryStageExecutionResponse,
  ListWebhookItem,
  GetPipelineExecutionRequest,
  PutJobFailureResultResponse,
  GetJobDetailsResponse,
  PutJobSuccessResultRequest,
  ListPipelineExecutionsRequest,
  EnableStageTransitionRequest,
  PipelineSummary,
  DisableStageTransitionRequest,
  StopPipelineExecutionRequest,
  ListActionTypesResponse,
  ListActionExecutionsRequest,
  RetryStageExecutionRequest,
  UpdateActionTypeRequest,
  PollForThirdPartyJobsResponse,
  GetActionTypeResponse,
  ListTagsForResourceRequest,
  Tag,
  GetJobDetailsRequest,
  ListActionTypesRequest,
  DeleteCustomActionTypeResponse,
  PutThirdPartyJobFailureResultResponse,
  PutThirdPartyJobSuccessResultResponse,
  PutWebhookResponse,
  ListPipelinesRequest,
  EnableStageTransitionResponse,
  ListWebhooksResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ActionExecutionDetail,
  GetPipelineStateRequest,
  UpdatePipelineResponse,
  UpdateActionTypeResponse,
  PutJobSuccessResultResponse,
  GetThirdPartyJobDetailsResponse,
  DeregisterWebhookWithThirdPartyRequest,
  GetThirdPartyJobDetailsRequest,
  PutWebhookRequest,
  ListPipelinesResponse,
  PutActionRevisionRequest,
  ListActionExecutionsResponse,
  CreatePipelineResponse,
  PutApprovalResultResponse,
  DeletePipelineRequest,
  AcknowledgeJobRequest,
  DisableStageTransitionResponse,
  RegisterWebhookWithThirdPartyRequest,
  GetActionTypeRequest,
  DeleteWebhookRequest,
  CreateCustomActionTypeRequest,
  UntagResourceRequest,
  RegisterWebhookWithThirdPartyResponse,
  ListWebhooksRequest,
  PollForJobsResponse,
  GetPipelineRequest,
  DeregisterWebhookWithThirdPartyResponse,
  ListPipelineExecutionsResponse,
  CreatePipelineRequest,
  PutThirdPartyJobSuccessResultRequest,
  UpdatePipelineRequest,
  StartPipelineExecutionResponse,
  TagResourceResponse,
  PutApprovalResultRequest,
  DeletePipelineResponse,
  PipelineExecutionSummary,
  CreateCustomActionTypeResponse,
  GetPipelineResponse,
  GetPipelineStateResponse,
  TagResourceRequest,
  DeleteWebhookResponse,
  StartPipelineExecutionRequest,
  AcknowledgeThirdPartyJobRequest,
  PutThirdPartyJobFailureResultRequest
}
import software.amazon.awssdk.services.codepipeline.{
  CodePipelineAsyncClientBuilder,
  CodePipelineAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait CodePipeline extends AspectSupport[CodePipeline] {
  val api: CodePipelineAsyncClient
  def retryStageExecution(
      request: zio.aws.codepipeline.model.RetryStageExecutionRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly
  ]
  def getPipeline(
      request: zio.aws.codepipeline.model.GetPipelineRequest
  ): IO[AwsError, zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly]
  def listPipelineExecutions(
      request: zio.aws.codepipeline.model.ListPipelineExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly
  ]
  def listPipelineExecutionsPaginated(
      request: zio.aws.codepipeline.model.ListPipelineExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly
  ]
  def listWebhooks(
      request: zio.aws.codepipeline.model.ListWebhooksRequest
  ): ZStream[Any, AwsError, zio.aws.codepipeline.model.ListWebhookItem.ReadOnly]
  def listWebhooksPaginated(
      request: zio.aws.codepipeline.model.ListWebhooksRequest
  ): IO[AwsError, zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly]
  def listActionExecutions(
      request: zio.aws.codepipeline.model.ListActionExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly
  ]
  def listActionExecutionsPaginated(
      request: zio.aws.codepipeline.model.ListActionExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly
  ]
  def updatePipeline(
      request: zio.aws.codepipeline.model.UpdatePipelineRequest
  ): IO[AwsError, zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly]
  def startPipelineExecution(
      request: zio.aws.codepipeline.model.StartPipelineExecutionRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly
  ]
  def putJobSuccessResult(
      request: zio.aws.codepipeline.model.PutJobSuccessResultRequest
  ): IO[AwsError, Unit]
  def deleteWebhook(
      request: zio.aws.codepipeline.model.DeleteWebhookRequest
  ): IO[AwsError, zio.aws.codepipeline.model.DeleteWebhookResponse.ReadOnly]
  def listActionTypes(
      request: zio.aws.codepipeline.model.ListActionTypesRequest
  ): ZStream[Any, AwsError, zio.aws.codepipeline.model.ActionType.ReadOnly]
  def listActionTypesPaginated(
      request: zio.aws.codepipeline.model.ListActionTypesRequest
  ): IO[AwsError, zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly]
  def acknowledgeThirdPartyJob(
      request: zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly
  ]
  def putJobFailureResult(
      request: zio.aws.codepipeline.model.PutJobFailureResultRequest
  ): IO[AwsError, Unit]
  def listPipelines(
      request: zio.aws.codepipeline.model.ListPipelinesRequest
  ): ZStream[Any, AwsError, zio.aws.codepipeline.model.PipelineSummary.ReadOnly]
  def listPipelinesPaginated(
      request: zio.aws.codepipeline.model.ListPipelinesRequest
  ): IO[AwsError, zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly]
  def acknowledgeJob(
      request: zio.aws.codepipeline.model.AcknowledgeJobRequest
  ): IO[AwsError, zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly]
  def updateActionType(
      request: zio.aws.codepipeline.model.UpdateActionTypeRequest
  ): IO[AwsError, Unit]
  def putApprovalResult(
      request: zio.aws.codepipeline.model.PutApprovalResultRequest
  ): IO[AwsError, zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly]
  def getPipelineState(
      request: zio.aws.codepipeline.model.GetPipelineStateRequest
  ): IO[AwsError, zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly]
  def pollForJobs(
      request: zio.aws.codepipeline.model.PollForJobsRequest
  ): IO[AwsError, zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.codepipeline.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.codepipeline.model.UntagResourceResponse.ReadOnly]
  def createCustomActionType(
      request: zio.aws.codepipeline.model.CreateCustomActionTypeRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly
  ]
  def pollForThirdPartyJobs(
      request: zio.aws.codepipeline.model.PollForThirdPartyJobsRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly
  ]
  def putThirdPartyJobFailureResult(
      request: zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest
  ): IO[AwsError, Unit]
  def putWebhook(
      request: zio.aws.codepipeline.model.PutWebhookRequest
  ): IO[AwsError, zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly]
  def deletePipeline(
      request: zio.aws.codepipeline.model.DeletePipelineRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(
      request: zio.aws.codepipeline.model.ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.codepipeline.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: zio.aws.codepipeline.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.codepipeline.model.TagResourceRequest
  ): IO[AwsError, zio.aws.codepipeline.model.TagResourceResponse.ReadOnly]
  def disableStageTransition(
      request: zio.aws.codepipeline.model.DisableStageTransitionRequest
  ): IO[AwsError, Unit]
  def deleteCustomActionType(
      request: zio.aws.codepipeline.model.DeleteCustomActionTypeRequest
  ): IO[AwsError, Unit]
  def putThirdPartyJobSuccessResult(
      request: zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest
  ): IO[AwsError, Unit]
  def getActionType(
      request: zio.aws.codepipeline.model.GetActionTypeRequest
  ): IO[AwsError, zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly]
  def stopPipelineExecution(
      request: zio.aws.codepipeline.model.StopPipelineExecutionRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly
  ]
  def deregisterWebhookWithThirdParty(
      request: zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyResponse.ReadOnly
  ]
  def registerWebhookWithThirdParty(
      request: zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyResponse.ReadOnly
  ]
  def createPipeline(
      request: zio.aws.codepipeline.model.CreatePipelineRequest
  ): IO[AwsError, zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly]
  def enableStageTransition(
      request: zio.aws.codepipeline.model.EnableStageTransitionRequest
  ): IO[AwsError, Unit]
  def getJobDetails(
      request: zio.aws.codepipeline.model.GetJobDetailsRequest
  ): IO[AwsError, zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly]
  def getThirdPartyJobDetails(
      request: zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest
  ): IO[
    AwsError,
    zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly
  ]
  def putActionRevision(
      request: zio.aws.codepipeline.model.PutActionRevisionRequest
  ): IO[AwsError, zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly]
  def getPipelineExecution(
      request: zio.aws.codepipeline.model.GetPipelineExecutionRequest
  ): IO[AwsError, ReadOnly]
}
object CodePipeline {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodePipeline] = customized(
    identity
  )
  def customized(
      customization: CodePipelineAsyncClientBuilder => CodePipelineAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodePipeline] = managed(
    customization
  ).toLayer
  def managed(
      customization: CodePipelineAsyncClientBuilder => CodePipelineAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CodePipeline] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CodePipelineAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CodePipelineAsyncClient, CodePipelineAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CodePipelineAsyncClient,
        CodePipelineAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CodePipelineImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CodePipelineImpl[R](
      override val api: CodePipelineAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodePipeline
      with AwsServiceBase[R] {
    override val serviceName: String = "CodePipeline"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodePipelineImpl[R1] = new CodePipelineImpl(api, newAspect, r)
    def retryStageExecution(
        request: zio.aws.codepipeline.model.RetryStageExecutionRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      RetryStageExecutionRequest,
      RetryStageExecutionResponse
    ]("retryStageExecution", api.retryStageExecution)(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.RetryStageExecutionResponse.wrap)
      .provideEnvironment(r)
    def getPipeline(
        request: zio.aws.codepipeline.model.GetPipelineRequest
    ): IO[AwsError, zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly] =
      asyncRequestResponse[GetPipelineRequest, GetPipelineResponse](
        "getPipeline",
        api.getPipeline
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.GetPipelineResponse.wrap)
        .provideEnvironment(r)
    def listPipelineExecutions(
        request: zio.aws.codepipeline.model.ListPipelineExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListPipelineExecutionsRequest,
      PipelineExecutionSummary,
      ListPipelineExecutionsPublisher
    ](
      "listPipelineExecutions",
      api.listPipelineExecutionsPaginator,
      _.pipelineExecutionSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codepipeline.model.PipelineExecutionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listPipelineExecutionsPaginated(
        request: zio.aws.codepipeline.model.ListPipelineExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPipelineExecutionsRequest,
      ListPipelineExecutionsResponse
    ]("listPipelineExecutions", api.listPipelineExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.ListPipelineExecutionsResponse.wrap)
      .provideEnvironment(r)
    def listWebhooks(
        request: zio.aws.codepipeline.model.ListWebhooksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ListWebhookItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListWebhooksRequest,
      ListWebhooksResponse,
      ListWebhookItem
    ](
      "listWebhooks",
      api.listWebhooks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.webhooks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.codepipeline.model.ListWebhookItem.wrap(item))
      .provideEnvironment(r)
    def listWebhooksPaginated(
        request: zio.aws.codepipeline.model.ListWebhooksRequest
    ): IO[AwsError, zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly] =
      asyncRequestResponse[ListWebhooksRequest, ListWebhooksResponse](
        "listWebhooks",
        api.listWebhooks
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.ListWebhooksResponse.wrap)
        .provideEnvironment(r)
    def listActionExecutions(
        request: zio.aws.codepipeline.model.ListActionExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListActionExecutionsRequest,
      ActionExecutionDetail,
      ListActionExecutionsPublisher
    ](
      "listActionExecutions",
      api.listActionExecutionsPaginator,
      _.actionExecutionDetails()
    )(request.buildAwsValue())
      .map(item => zio.aws.codepipeline.model.ActionExecutionDetail.wrap(item))
      .provideEnvironment(r)
    def listActionExecutionsPaginated(
        request: zio.aws.codepipeline.model.ListActionExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListActionExecutionsRequest,
      ListActionExecutionsResponse
    ]("listActionExecutions", api.listActionExecutions)(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.ListActionExecutionsResponse.wrap)
      .provideEnvironment(r)
    def updatePipeline(
        request: zio.aws.codepipeline.model.UpdatePipelineRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[UpdatePipelineRequest, UpdatePipelineResponse](
      "updatePipeline",
      api.updatePipeline
    )(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.UpdatePipelineResponse.wrap)
      .provideEnvironment(r)
    def startPipelineExecution(
        request: zio.aws.codepipeline.model.StartPipelineExecutionRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartPipelineExecutionRequest,
      StartPipelineExecutionResponse
    ]("startPipelineExecution", api.startPipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.StartPipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def putJobSuccessResult(
        request: zio.aws.codepipeline.model.PutJobSuccessResultRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutJobSuccessResultRequest,
      PutJobSuccessResultResponse
    ]("putJobSuccessResult", api.putJobSuccessResult)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteWebhook(
        request: zio.aws.codepipeline.model.DeleteWebhookRequest
    ): IO[AwsError, zio.aws.codepipeline.model.DeleteWebhookResponse.ReadOnly] =
      asyncRequestResponse[DeleteWebhookRequest, DeleteWebhookResponse](
        "deleteWebhook",
        api.deleteWebhook
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.DeleteWebhookResponse.wrap)
        .provideEnvironment(r)
    def listActionTypes(
        request: zio.aws.codepipeline.model.ListActionTypesRequest
    ): ZStream[Any, AwsError, zio.aws.codepipeline.model.ActionType.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListActionTypesRequest,
        ActionType,
        ListActionTypesPublisher
      ]("listActionTypes", api.listActionTypesPaginator, _.actionTypes())(
        request.buildAwsValue()
      ).map(item => zio.aws.codepipeline.model.ActionType.wrap(item))
        .provideEnvironment(r)
    def listActionTypesPaginated(
        request: zio.aws.codepipeline.model.ListActionTypesRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly
    ] = asyncRequestResponse[ListActionTypesRequest, ListActionTypesResponse](
      "listActionTypes",
      api.listActionTypes
    )(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.ListActionTypesResponse.wrap)
      .provideEnvironment(r)
    def acknowledgeThirdPartyJob(
        request: zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly
    ] = asyncRequestResponse[
      AcknowledgeThirdPartyJobRequest,
      AcknowledgeThirdPartyJobResponse
    ]("acknowledgeThirdPartyJob", api.acknowledgeThirdPartyJob)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.wrap)
      .provideEnvironment(r)
    def putJobFailureResult(
        request: zio.aws.codepipeline.model.PutJobFailureResultRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutJobFailureResultRequest,
      PutJobFailureResultResponse
    ]("putJobFailureResult", api.putJobFailureResult)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listPipelines(
        request: zio.aws.codepipeline.model.ListPipelinesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListPipelinesRequest,
      PipelineSummary,
      ListPipelinesPublisher
    ]("listPipelines", api.listPipelinesPaginator, _.pipelines())(
      request.buildAwsValue()
    ).map(item => zio.aws.codepipeline.model.PipelineSummary.wrap(item))
      .provideEnvironment(r)
    def listPipelinesPaginated(
        request: zio.aws.codepipeline.model.ListPipelinesRequest
    ): IO[AwsError, zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly] =
      asyncRequestResponse[ListPipelinesRequest, ListPipelinesResponse](
        "listPipelines",
        api.listPipelines
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.ListPipelinesResponse.wrap)
        .provideEnvironment(r)
    def acknowledgeJob(
        request: zio.aws.codepipeline.model.AcknowledgeJobRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly
    ] = asyncRequestResponse[AcknowledgeJobRequest, AcknowledgeJobResponse](
      "acknowledgeJob",
      api.acknowledgeJob
    )(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.AcknowledgeJobResponse.wrap)
      .provideEnvironment(r)
    def updateActionType(
        request: zio.aws.codepipeline.model.UpdateActionTypeRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateActionTypeRequest, UpdateActionTypeResponse](
        "updateActionType",
        api.updateActionType
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putApprovalResult(
        request: zio.aws.codepipeline.model.PutApprovalResultRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly
    ] =
      asyncRequestResponse[PutApprovalResultRequest, PutApprovalResultResponse](
        "putApprovalResult",
        api.putApprovalResult
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.PutApprovalResultResponse.wrap)
        .provideEnvironment(r)
    def getPipelineState(
        request: zio.aws.codepipeline.model.GetPipelineStateRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly
    ] = asyncRequestResponse[GetPipelineStateRequest, GetPipelineStateResponse](
      "getPipelineState",
      api.getPipelineState
    )(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.GetPipelineStateResponse.wrap)
      .provideEnvironment(r)
    def pollForJobs(
        request: zio.aws.codepipeline.model.PollForJobsRequest
    ): IO[AwsError, zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly] =
      asyncRequestResponse[PollForJobsRequest, PollForJobsResponse](
        "pollForJobs",
        api.pollForJobs
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.PollForJobsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.codepipeline.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.codepipeline.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createCustomActionType(
        request: zio.aws.codepipeline.model.CreateCustomActionTypeRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCustomActionTypeRequest,
      CreateCustomActionTypeResponse
    ]("createCustomActionType", api.createCustomActionType)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.CreateCustomActionTypeResponse.wrap)
      .provideEnvironment(r)
    def pollForThirdPartyJobs(
        request: zio.aws.codepipeline.model.PollForThirdPartyJobsRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      PollForThirdPartyJobsRequest,
      PollForThirdPartyJobsResponse
    ]("pollForThirdPartyJobs", api.pollForThirdPartyJobs)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.wrap)
      .provideEnvironment(r)
    def putThirdPartyJobFailureResult(
        request: zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutThirdPartyJobFailureResultRequest,
      PutThirdPartyJobFailureResultResponse
    ]("putThirdPartyJobFailureResult", api.putThirdPartyJobFailureResult)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putWebhook(
        request: zio.aws.codepipeline.model.PutWebhookRequest
    ): IO[AwsError, zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly] =
      asyncRequestResponse[PutWebhookRequest, PutWebhookResponse](
        "putWebhook",
        api.putWebhook
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.PutWebhookResponse.wrap)
        .provideEnvironment(r)
    def deletePipeline(
        request: zio.aws.codepipeline.model.DeletePipelineRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeletePipelineRequest, DeletePipelineResponse](
        "deletePipeline",
        api.deletePipeline
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.codepipeline.model.ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.codepipeline.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListTagsForResourceRequest,
        Tag,
        ListTagsForResourcePublisher
      ]("listTagsForResource", api.listTagsForResourcePaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.codepipeline.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.codepipeline.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.codepipeline.model.TagResourceRequest
    ): IO[AwsError, zio.aws.codepipeline.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def disableStageTransition(
        request: zio.aws.codepipeline.model.DisableStageTransitionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisableStageTransitionRequest,
      DisableStageTransitionResponse
    ]("disableStageTransition", api.disableStageTransition)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteCustomActionType(
        request: zio.aws.codepipeline.model.DeleteCustomActionTypeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteCustomActionTypeRequest,
      DeleteCustomActionTypeResponse
    ]("deleteCustomActionType", api.deleteCustomActionType)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putThirdPartyJobSuccessResult(
        request: zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutThirdPartyJobSuccessResultRequest,
      PutThirdPartyJobSuccessResultResponse
    ]("putThirdPartyJobSuccessResult", api.putThirdPartyJobSuccessResult)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getActionType(
        request: zio.aws.codepipeline.model.GetActionTypeRequest
    ): IO[AwsError, zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly] =
      asyncRequestResponse[GetActionTypeRequest, GetActionTypeResponse](
        "getActionType",
        api.getActionType
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.GetActionTypeResponse.wrap)
        .provideEnvironment(r)
    def stopPipelineExecution(
        request: zio.aws.codepipeline.model.StopPipelineExecutionRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      StopPipelineExecutionRequest,
      StopPipelineExecutionResponse
    ]("stopPipelineExecution", api.stopPipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.StopPipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def deregisterWebhookWithThirdParty(
        request: zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterWebhookWithThirdPartyRequest,
      DeregisterWebhookWithThirdPartyResponse
    ]("deregisterWebhookWithThirdParty", api.deregisterWebhookWithThirdParty)(
      request.buildAwsValue()
    ).map(
      zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyResponse.wrap
    ).provideEnvironment(r)
    def registerWebhookWithThirdParty(
        request: zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterWebhookWithThirdPartyRequest,
      RegisterWebhookWithThirdPartyResponse
    ]("registerWebhookWithThirdParty", api.registerWebhookWithThirdParty)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyResponse.wrap)
      .provideEnvironment(r)
    def createPipeline(
        request: zio.aws.codepipeline.model.CreatePipelineRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[CreatePipelineRequest, CreatePipelineResponse](
      "createPipeline",
      api.createPipeline
    )(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.CreatePipelineResponse.wrap)
      .provideEnvironment(r)
    def enableStageTransition(
        request: zio.aws.codepipeline.model.EnableStageTransitionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      EnableStageTransitionRequest,
      EnableStageTransitionResponse
    ]("enableStageTransition", api.enableStageTransition)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getJobDetails(
        request: zio.aws.codepipeline.model.GetJobDetailsRequest
    ): IO[AwsError, zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly] =
      asyncRequestResponse[GetJobDetailsRequest, GetJobDetailsResponse](
        "getJobDetails",
        api.getJobDetails
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.GetJobDetailsResponse.wrap)
        .provideEnvironment(r)
    def getThirdPartyJobDetails(
        request: zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetThirdPartyJobDetailsRequest,
      GetThirdPartyJobDetailsResponse
    ]("getThirdPartyJobDetails", api.getThirdPartyJobDetails)(
      request.buildAwsValue()
    ).map(zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.wrap)
      .provideEnvironment(r)
    def putActionRevision(
        request: zio.aws.codepipeline.model.PutActionRevisionRequest
    ): IO[
      AwsError,
      zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly
    ] =
      asyncRequestResponse[PutActionRevisionRequest, PutActionRevisionResponse](
        "putActionRevision",
        api.putActionRevision
      )(request.buildAwsValue())
        .map(zio.aws.codepipeline.model.PutActionRevisionResponse.wrap)
        .provideEnvironment(r)
    def getPipelineExecution(
        request: zio.aws.codepipeline.model.GetPipelineExecutionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetPipelineExecutionRequest,
      GetPipelineExecutionResponse
    ]("getPipelineExecution", api.getPipelineExecution)(request.buildAwsValue())
      .map(zio.aws.codepipeline.model.GetPipelineExecutionResponse.wrap)
      .provideEnvironment(r)
  }
  def retryStageExecution(
      request: zio.aws.codepipeline.model.RetryStageExecutionRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retryStageExecution(request))
  def getPipeline(request: zio.aws.codepipeline.model.GetPipelineRequest): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPipeline(request))
  def listPipelineExecutions(
      request: zio.aws.codepipeline.model.ListPipelineExecutionsRequest
  ): ZStream[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelineExecutions(request))
  def listPipelineExecutionsPaginated(
      request: zio.aws.codepipeline.model.ListPipelineExecutionsRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelineExecutionsPaginated(request))
  def listWebhooks(
      request: zio.aws.codepipeline.model.ListWebhooksRequest
  ): ZStream[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ListWebhookItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listWebhooks(request))
  def listWebhooksPaginated(
      request: zio.aws.codepipeline.model.ListWebhooksRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWebhooksPaginated(request))
  def listActionExecutions(
      request: zio.aws.codepipeline.model.ListActionExecutionsRequest
  ): ZStream[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.listActionExecutions(request))
  def listActionExecutionsPaginated(
      request: zio.aws.codepipeline.model.ListActionExecutionsRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listActionExecutionsPaginated(request))
  def updatePipeline(
      request: zio.aws.codepipeline.model.UpdatePipelineRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePipeline(request))
  def startPipelineExecution(
      request: zio.aws.codepipeline.model.StartPipelineExecutionRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startPipelineExecution(request))
  def putJobSuccessResult(
      request: zio.aws.codepipeline.model.PutJobSuccessResultRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putJobSuccessResult(request))
  def deleteWebhook(
      request: zio.aws.codepipeline.model.DeleteWebhookRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.DeleteWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWebhook(request))
  def listActionTypes(
      request: zio.aws.codepipeline.model.ListActionTypesRequest
  ): ZStream[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ActionType.ReadOnly
  ] = ZStream.serviceWithStream(_.listActionTypes(request))
  def listActionTypesPaginated(
      request: zio.aws.codepipeline.model.ListActionTypesRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listActionTypesPaginated(request))
  def acknowledgeThirdPartyJob(
      request: zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acknowledgeThirdPartyJob(request))
  def putJobFailureResult(
      request: zio.aws.codepipeline.model.PutJobFailureResultRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putJobFailureResult(request))
  def listPipelines(
      request: zio.aws.codepipeline.model.ListPipelinesRequest
  ): ZStream[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.PipelineSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelines(request))
  def listPipelinesPaginated(
      request: zio.aws.codepipeline.model.ListPipelinesRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelinesPaginated(request))
  def acknowledgeJob(
      request: zio.aws.codepipeline.model.AcknowledgeJobRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acknowledgeJob(request))
  def updateActionType(
      request: zio.aws.codepipeline.model.UpdateActionTypeRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateActionType(request))
  def putApprovalResult(
      request: zio.aws.codepipeline.model.PutApprovalResultRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putApprovalResult(request))
  def getPipelineState(
      request: zio.aws.codepipeline.model.GetPipelineStateRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPipelineState(request))
  def pollForJobs(request: zio.aws.codepipeline.model.PollForJobsRequest): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.pollForJobs(request))
  def untagResource(
      request: zio.aws.codepipeline.model.UntagResourceRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createCustomActionType(
      request: zio.aws.codepipeline.model.CreateCustomActionTypeRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomActionType(request))
  def pollForThirdPartyJobs(
      request: zio.aws.codepipeline.model.PollForThirdPartyJobsRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.pollForThirdPartyJobs(request))
  def putThirdPartyJobFailureResult(
      request: zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putThirdPartyJobFailureResult(request))
  def putWebhook(request: zio.aws.codepipeline.model.PutWebhookRequest): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putWebhook(request))
  def deletePipeline(
      request: zio.aws.codepipeline.model.DeletePipelineRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePipeline(request))
  def listTagsForResource(
      request: zio.aws.codepipeline.model.ListTagsForResourceRequest
  ): ZStream[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.codepipeline.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: zio.aws.codepipeline.model.TagResourceRequest): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def disableStageTransition(
      request: zio.aws.codepipeline.model.DisableStageTransitionRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableStageTransition(request))
  def deleteCustomActionType(
      request: zio.aws.codepipeline.model.DeleteCustomActionTypeRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCustomActionType(request))
  def putThirdPartyJobSuccessResult(
      request: zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putThirdPartyJobSuccessResult(request))
  def getActionType(
      request: zio.aws.codepipeline.model.GetActionTypeRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getActionType(request))
  def stopPipelineExecution(
      request: zio.aws.codepipeline.model.StopPipelineExecutionRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopPipelineExecution(request))
  def deregisterWebhookWithThirdParty(
      request: zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterWebhookWithThirdParty(request))
  def registerWebhookWithThirdParty(
      request: zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerWebhookWithThirdParty(request))
  def createPipeline(
      request: zio.aws.codepipeline.model.CreatePipelineRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPipeline(request))
  def enableStageTransition(
      request: zio.aws.codepipeline.model.EnableStageTransitionRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableStageTransition(request))
  def getJobDetails(
      request: zio.aws.codepipeline.model.GetJobDetailsRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJobDetails(request))
  def getThirdPartyJobDetails(
      request: zio.aws.codepipeline.model.GetThirdPartyJobDetailsRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getThirdPartyJobDetails(request))
  def putActionRevision(
      request: zio.aws.codepipeline.model.PutActionRevisionRequest
  ): ZIO[
    zio.aws.codepipeline.CodePipeline,
    AwsError,
    zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putActionRevision(request))
  def getPipelineExecution(
      request: zio.aws.codepipeline.model.GetPipelineExecutionRequest
  ): ZIO[zio.aws.codepipeline.CodePipeline, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getPipelineExecution(request))
}
