package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPipelinesResponse(
    pipelines: Option[Iterable[zio.aws.codepipeline.model.PipelineSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse = {
    import ListPipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse
      .builder()
      .optionallyWith(
        pipelines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelines)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly =
    zio.aws.codepipeline.model.ListPipelinesResponse.wrap(buildAwsValue())
}
object ListPipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListPipelinesResponse =
      zio.aws.codepipeline.model.ListPipelinesResponse(
        pipelines.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pipelines
        : Option[List[zio.aws.codepipeline.model.PipelineSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getPipelines: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.PipelineSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelines", pipelines)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse
  ) extends zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly {
    override val pipelines
        : Option[List[zio.aws.codepipeline.model.PipelineSummary.ReadOnly]] =
      scala
        .Option(impl.pipelines())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.PipelineSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse
  ): zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly = new Wrapper(
    impl
  )
}
