package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  Url,
  ExternalExecutionSummary,
  ExternalExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActionExecutionResult(
    externalExecutionId: Option[ExternalExecutionId] = None,
    externalExecutionSummary: Option[ExternalExecutionSummary] = None,
    externalExecutionUrl: Option[Url] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionExecutionResult = {
    import ActionExecutionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionResult
      .builder()
      .optionallyWith(
        externalExecutionId.map(value =>
          ExternalExecutionId.unwrap(value): java.lang.String
        )
      )(_.externalExecutionId)
      .optionallyWith(
        externalExecutionSummary.map(value =>
          ExternalExecutionSummary.unwrap(value): java.lang.String
        )
      )(_.externalExecutionSummary)
      .optionallyWith(
        externalExecutionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.externalExecutionUrl)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionExecutionResult.ReadOnly =
    zio.aws.codepipeline.model.ActionExecutionResult.wrap(buildAwsValue())
}
object ActionExecutionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionExecutionResult =
      zio.aws.codepipeline.model.ActionExecutionResult(
        externalExecutionId.map(value => value),
        externalExecutionSummary.map(value => value),
        externalExecutionUrl.map(value => value)
      )
    def externalExecutionId: Option[ExternalExecutionId]
    def externalExecutionSummary: Option[ExternalExecutionSummary]
    def externalExecutionUrl: Option[Url]
    def getExternalExecutionId: ZIO[Any, AwsError, ExternalExecutionId] =
      AwsError.unwrapOptionField("externalExecutionId", externalExecutionId)
    def getExternalExecutionSummary
        : ZIO[Any, AwsError, ExternalExecutionSummary] = AwsError
      .unwrapOptionField("externalExecutionSummary", externalExecutionSummary)
    def getExternalExecutionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("externalExecutionUrl", externalExecutionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionResult
  ) extends zio.aws.codepipeline.model.ActionExecutionResult.ReadOnly {
    override val externalExecutionId: Option[ExternalExecutionId] = scala
      .Option(impl.externalExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ExternalExecutionId(value)
      )
    override val externalExecutionSummary: Option[ExternalExecutionSummary] =
      scala
        .Option(impl.externalExecutionSummary())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ExternalExecutionSummary(value)
        )
    override val externalExecutionUrl: Option[Url] = scala
      .Option(impl.externalExecutionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionResult
  ): zio.aws.codepipeline.model.ActionExecutionResult.ReadOnly = new Wrapper(
    impl
  )
}
