package zio.aws.codepipeline.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  ActionExecutionToken,
  Url,
  Percentage,
  Timestamp,
  ActionExecutionId,
  ExecutionId,
  ExecutionSummary,
  LastUpdatedBy
}
import scala.jdk.CollectionConverters.*
final case class ActionExecution(
    actionExecutionId: Option[ActionExecutionId] = None,
    status: Option[zio.aws.codepipeline.model.ActionExecutionStatus] = None,
    summary: Option[ExecutionSummary] = None,
    lastStatusChange: Option[Timestamp] = None,
    token: Option[ActionExecutionToken] = None,
    lastUpdatedBy: Option[LastUpdatedBy] = None,
    externalExecutionId: Option[ExecutionId] = None,
    externalExecutionUrl: Option[Url] = None,
    percentComplete: Option[Percentage] = None,
    errorDetails: Option[zio.aws.codepipeline.model.ErrorDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionExecution = {
    import ActionExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionExecution
      .builder()
      .optionallyWith(
        actionExecutionId.map(value =>
          ActionExecutionId.unwrap(value): java.lang.String
        )
      )(_.actionExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        summary.map(value => ExecutionSummary.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(
        lastStatusChange.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStatusChange)
      .optionallyWith(
        token.map(value => ActionExecutionToken.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        lastUpdatedBy.map(value =>
          LastUpdatedBy.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedBy)
      .optionallyWith(
        externalExecutionId.map(value =>
          ExecutionId.unwrap(value): java.lang.String
        )
      )(_.externalExecutionId)
      .optionallyWith(
        externalExecutionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.externalExecutionUrl)
      .optionallyWith(
        percentComplete.map(value => Percentage.unwrap(value): Integer)
      )(_.percentComplete)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionExecution.ReadOnly =
    zio.aws.codepipeline.model.ActionExecution.wrap(buildAwsValue())
}
object ActionExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionExecution =
      zio.aws.codepipeline.model.ActionExecution(
        actionExecutionId.map(value => value),
        status.map(value => value),
        summary.map(value => value),
        lastStatusChange.map(value => value),
        token.map(value => value),
        lastUpdatedBy.map(value => value),
        externalExecutionId.map(value => value),
        externalExecutionUrl.map(value => value),
        percentComplete.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def actionExecutionId: Option[ActionExecutionId]
    def status: Option[zio.aws.codepipeline.model.ActionExecutionStatus]
    def summary: Option[ExecutionSummary]
    def lastStatusChange: Option[Timestamp]
    def token: Option[ActionExecutionToken]
    def lastUpdatedBy: Option[LastUpdatedBy]
    def externalExecutionId: Option[ExecutionId]
    def externalExecutionUrl: Option[Url]
    def percentComplete: Option[Percentage]
    def errorDetails: Option[zio.aws.codepipeline.model.ErrorDetails.ReadOnly]
    def getActionExecutionId: ZIO[Any, AwsError, ActionExecutionId] =
      AwsError.unwrapOptionField("actionExecutionId", actionExecutionId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSummary: ZIO[Any, AwsError, ExecutionSummary] =
      AwsError.unwrapOptionField("summary", summary)
    def getLastStatusChange: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
    def getToken: ZIO[Any, AwsError, ActionExecutionToken] =
      AwsError.unwrapOptionField("token", token)
    def getLastUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getExternalExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("externalExecutionId", externalExecutionId)
    def getExternalExecutionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("externalExecutionUrl", externalExecutionUrl)
    def getPercentComplete: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentComplete", percentComplete)
    def getErrorDetails
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecution
  ) extends zio.aws.codepipeline.model.ActionExecution.ReadOnly {
    override val actionExecutionId: Option[ActionExecutionId] = scala
      .Option(impl.actionExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ActionExecutionId(value)
      )
    override val status
        : Option[zio.aws.codepipeline.model.ActionExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.codepipeline.model.ActionExecutionStatus.wrap(value)
      )
    override val summary: Option[ExecutionSummary] = scala
      .Option(impl.summary())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ExecutionSummary(value)
      )
    override val lastStatusChange: Option[Timestamp] = scala
      .Option(impl.lastStatusChange())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val token: Option[ActionExecutionToken] = scala
      .Option(impl.token())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ActionExecutionToken(value)
      )
    override val lastUpdatedBy: Option[LastUpdatedBy] = scala
      .Option(impl.lastUpdatedBy())
      .map(value => zio.aws.codepipeline.model.primitives.LastUpdatedBy(value))
    override val externalExecutionId: Option[ExecutionId] = scala
      .Option(impl.externalExecutionId())
      .map(value => zio.aws.codepipeline.model.primitives.ExecutionId(value))
    override val externalExecutionUrl: Option[Url] = scala
      .Option(impl.externalExecutionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val percentComplete: Option[Percentage] = scala
      .Option(impl.percentComplete())
      .map(value => zio.aws.codepipeline.model.primitives.Percentage(value))
    override val errorDetails
        : Option[zio.aws.codepipeline.model.ErrorDetails.ReadOnly] = scala
      .Option(impl.errorDetails())
      .map(value => zio.aws.codepipeline.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecution
  ): zio.aws.codepipeline.model.ActionExecution.ReadOnly = new Wrapper(impl)
}
