package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{AccountId, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobDetails(
    id: Option[JobId] = None,
    data: Option[zio.aws.codepipeline.model.JobData] = None,
    accountId: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.JobDetails = {
    import JobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.JobDetails
      .builder()
      .optionallyWith(id.map(value => JobId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(data.map(value => value.buildAwsValue()))(_.data)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.JobDetails.ReadOnly =
    zio.aws.codepipeline.model.JobDetails.wrap(buildAwsValue())
}
object JobDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.JobDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.JobDetails =
      zio.aws.codepipeline.model.JobDetails(
        id.map(value => value),
        data.map(value => value.asEditable),
        accountId.map(value => value)
      )
    def id: Option[JobId]
    def data: Option[zio.aws.codepipeline.model.JobData.ReadOnly]
    def accountId: Option[AccountId]
    def getId: ZIO[Any, AwsError, JobId] = AwsError.unwrapOptionField("id", id)
    def getData
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.JobData.ReadOnly] =
      AwsError.unwrapOptionField("data", data)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.JobDetails
  ) extends zio.aws.codepipeline.model.JobDetails.ReadOnly {
    override val id: Option[JobId] = scala
      .Option(impl.id())
      .map(value => zio.aws.codepipeline.model.primitives.JobId(value))
    override val data: Option[zio.aws.codepipeline.model.JobData.ReadOnly] =
      scala
        .Option(impl.data())
        .map(value => zio.aws.codepipeline.model.JobData.wrap(value))
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.codepipeline.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.JobDetails
  ): zio.aws.codepipeline.model.JobDetails.ReadOnly = new Wrapper(impl)
}
