package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.GitTagNamePattern
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GitTagFilterCriteria(
    includes: Optional[Iterable[GitTagNamePattern]] = Optional.Absent,
    excludes: Optional[Iterable[GitTagNamePattern]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GitTagFilterCriteria = {
    import GitTagFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GitTagFilterCriteria
      .builder()
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            GitTagNamePattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            GitTagNamePattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludes)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GitTagFilterCriteria.ReadOnly =
    zio.aws.codepipeline.model.GitTagFilterCriteria.wrap(buildAwsValue())
}
object GitTagFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GitTagFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GitTagFilterCriteria =
      zio.aws.codepipeline.model.GitTagFilterCriteria(
        includes.map(value => value),
        excludes.map(value => value)
      )
    def includes: Optional[List[GitTagNamePattern]]
    def excludes: Optional[List[GitTagNamePattern]]
    def getIncludes: ZIO[Any, AwsError, List[GitTagNamePattern]] =
      AwsError.unwrapOptionField("includes", includes)
    def getExcludes: ZIO[Any, AwsError, List[GitTagNamePattern]] =
      AwsError.unwrapOptionField("excludes", excludes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GitTagFilterCriteria
  ) extends zio.aws.codepipeline.model.GitTagFilterCriteria.ReadOnly {
    override val includes: Optional[List[GitTagNamePattern]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.GitTagNamePattern(item)
          }.toList
        )
    override val excludes: Optional[List[GitTagNamePattern]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.GitTagNamePattern(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GitTagFilterCriteria
  ): zio.aws.codepipeline.model.GitTagFilterCriteria.ReadOnly = new Wrapper(
    impl
  )
}
