package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait PipelineTriggerProviderType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType
}
object PipelineTriggerProviderType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType
  ): zio.aws.codepipeline.model.PipelineTriggerProviderType = value match {
    case software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType.CODE_STAR_SOURCE_CONNECTION =>
      val r = CodeStarSourceConnection
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.PipelineTriggerProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType =
      software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object CodeStarSourceConnection
      extends zio.aws.codepipeline.model.PipelineTriggerProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType =
      software.amazon.awssdk.services.codepipeline.model.PipelineTriggerProviderType.CODE_STAR_SOURCE_CONNECTION
  }
}
