package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait PipelineType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.PipelineType
}
object PipelineType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.PipelineType
  ): zio.aws.codepipeline.model.PipelineType = value match {
    case software.amazon.awssdk.services.codepipeline.model.PipelineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineType.V1 =>
      val r = V1
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineType.V2 =>
      val r = V2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.PipelineType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineType =
      software.amazon.awssdk.services.codepipeline.model.PipelineType.UNKNOWN_TO_SDK_VERSION
  }
  case object V1 extends zio.aws.codepipeline.model.PipelineType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineType =
      software.amazon.awssdk.services.codepipeline.model.PipelineType.V1
  }
  case object V2 extends zio.aws.codepipeline.model.PipelineType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineType =
      software.amazon.awssdk.services.codepipeline.model.PipelineType.V2
  }
}
