package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GitPushFilter(
    tags: Optional[zio.aws.codepipeline.model.GitTagFilterCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GitPushFilter = {
    import GitPushFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GitPushFilter
      .builder()
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GitPushFilter.ReadOnly =
    zio.aws.codepipeline.model.GitPushFilter.wrap(buildAwsValue())
}
object GitPushFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GitPushFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GitPushFilter =
      zio.aws.codepipeline.model
        .GitPushFilter(tags.map(value => value.asEditable))
    def tags: Optional[zio.aws.codepipeline.model.GitTagFilterCriteria.ReadOnly]
    def getTags: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.GitTagFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GitPushFilter
  ) extends zio.aws.codepipeline.model.GitPushFilter.ReadOnly {
    override val tags
        : Optional[zio.aws.codepipeline.model.GitTagFilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          zio.aws.codepipeline.model.GitTagFilterCriteria.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GitPushFilter
  ): zio.aws.codepipeline.model.GitPushFilter.ReadOnly = new Wrapper(impl)
}
