package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PipelineVariableDescription,
  PipelineVariableValue,
  PipelineVariableName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PipelineVariableDeclaration(
    name: PipelineVariableName,
    defaultValue: Optional[PipelineVariableValue] = Optional.Absent,
    description: Optional[PipelineVariableDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineVariableDeclaration = {
    import PipelineVariableDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineVariableDeclaration
      .builder()
      .name(PipelineVariableName.unwrap(name): java.lang.String)
      .optionallyWith(
        defaultValue.map(value =>
          PipelineVariableValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .optionallyWith(
        description.map(value =>
          PipelineVariableDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PipelineVariableDeclaration.ReadOnly =
    zio.aws.codepipeline.model.PipelineVariableDeclaration.wrap(buildAwsValue())
}
object PipelineVariableDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineVariableDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineVariableDeclaration =
      zio.aws.codepipeline.model.PipelineVariableDeclaration(
        name,
        defaultValue.map(value => value),
        description.map(value => value)
      )
    def name: PipelineVariableName
    def defaultValue: Optional[PipelineVariableValue]
    def description: Optional[PipelineVariableDescription]
    def getName: ZIO[Any, Nothing, PipelineVariableName] = ZIO.succeed(name)
    def getDefaultValue: ZIO[Any, AwsError, PipelineVariableValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, PipelineVariableDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineVariableDeclaration
  ) extends zio.aws.codepipeline.model.PipelineVariableDeclaration.ReadOnly {
    override val name: PipelineVariableName =
      zio.aws.codepipeline.model.primitives.PipelineVariableName(impl.name())
    override val defaultValue: Optional[PipelineVariableValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineVariableValue(value)
        )
    override val description: Optional[PipelineVariableDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codepipeline.model.primitives
            .PipelineVariableDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineVariableDeclaration
  ): zio.aws.codepipeline.model.PipelineVariableDeclaration.ReadOnly =
    new Wrapper(impl)
}
