package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ActionName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GitConfiguration(
    sourceActionName: ActionName,
    push: Optional[Iterable[zio.aws.codepipeline.model.GitPushFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GitConfiguration = {
    import GitConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GitConfiguration
      .builder()
      .sourceActionName(ActionName.unwrap(sourceActionName): java.lang.String)
      .optionallyWith(
        push.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.push)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GitConfiguration.ReadOnly =
    zio.aws.codepipeline.model.GitConfiguration.wrap(buildAwsValue())
}
object GitConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GitConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GitConfiguration =
      zio.aws.codepipeline.model.GitConfiguration(
        sourceActionName,
        push.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceActionName: ActionName
    def push: Optional[List[zio.aws.codepipeline.model.GitPushFilter.ReadOnly]]
    def getSourceActionName: ZIO[Any, Nothing, ActionName] =
      ZIO.succeed(sourceActionName)
    def getPush: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.GitPushFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("push", push)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GitConfiguration
  ) extends zio.aws.codepipeline.model.GitConfiguration.ReadOnly {
    override val sourceActionName: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.sourceActionName())
    override val push
        : Optional[List[zio.aws.codepipeline.model.GitPushFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.push())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.GitPushFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GitConfiguration
  ): zio.aws.codepipeline.model.GitConfiguration.ReadOnly = new Wrapper(impl)
}
