package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  OutputVariablesValue,
  OutputVariablesKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionExecutionOutput(
    outputArtifacts: Optional[
      Iterable[zio.aws.codepipeline.model.ArtifactDetail]
    ] = Optional.Absent,
    executionResult: Optional[
      zio.aws.codepipeline.model.ActionExecutionResult
    ] = Optional.Absent,
    outputVariables: Optional[Map[OutputVariablesKey, OutputVariablesValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionExecutionOutput = {
    import ActionExecutionOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionOutput
      .builder()
      .optionallyWith(
        outputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputArtifacts)
      .optionallyWith(executionResult.map(value => value.buildAwsValue()))(
        _.executionResult
      )
      .optionallyWith(
        outputVariables.map(value =>
          value
            .map({ case (key, value) =>
              (OutputVariablesKey
                .unwrap(key): java.lang.String) -> (OutputVariablesValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.outputVariables)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionExecutionOutput.ReadOnly =
    zio.aws.codepipeline.model.ActionExecutionOutput.wrap(buildAwsValue())
}
object ActionExecutionOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionExecutionOutput =
      zio.aws.codepipeline.model.ActionExecutionOutput(
        outputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionResult.map(value => value.asEditable),
        outputVariables.map(value => value)
      )
    def outputArtifacts
        : Optional[List[zio.aws.codepipeline.model.ArtifactDetail.ReadOnly]]
    def executionResult
        : Optional[zio.aws.codepipeline.model.ActionExecutionResult.ReadOnly]
    def outputVariables: Optional[Map[OutputVariablesKey, OutputVariablesValue]]
    def getOutputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ArtifactDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getExecutionResult: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionExecutionResult.ReadOnly
    ] = AwsError.unwrapOptionField("executionResult", executionResult)
    def getOutputVariables
        : ZIO[Any, AwsError, Map[OutputVariablesKey, OutputVariablesValue]] =
      AwsError.unwrapOptionField("outputVariables", outputVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionOutput
  ) extends zio.aws.codepipeline.model.ActionExecutionOutput.ReadOnly {
    override val outputArtifacts
        : Optional[List[zio.aws.codepipeline.model.ArtifactDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ArtifactDetail.wrap(item)
          }.toList
        )
    override val executionResult
        : Optional[zio.aws.codepipeline.model.ActionExecutionResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionResult())
        .map(value =>
          zio.aws.codepipeline.model.ActionExecutionResult.wrap(value)
        )
    override val outputVariables
        : Optional[Map[OutputVariablesKey, OutputVariablesValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codepipeline.model.primitives.OutputVariablesKey(
                key
              ) -> zio.aws.codepipeline.model.primitives
                .OutputVariablesValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionOutput
  ): zio.aws.codepipeline.model.ActionExecutionOutput.ReadOnly = new Wrapper(
    impl
  )
}
