package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Revision, ArtifactName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Artifact(
    name: Optional[ArtifactName] = Optional.Absent,
    revision: Optional[Revision] = Optional.Absent,
    location: Optional[zio.aws.codepipeline.model.ArtifactLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.Artifact = {
    import Artifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.Artifact
      .builder()
      .optionallyWith(
        name.map(value => ArtifactName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.Artifact.ReadOnly =
    zio.aws.codepipeline.model.Artifact.wrap(buildAwsValue())
}
object Artifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.Artifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.Artifact =
      zio.aws.codepipeline.model.Artifact(
        name.map(value => value),
        revision.map(value => value),
        location.map(value => value.asEditable)
      )
    def name: Optional[ArtifactName]
    def revision: Optional[Revision]
    def location: Optional[zio.aws.codepipeline.model.ArtifactLocation.ReadOnly]
    def getName: ZIO[Any, AwsError, ArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ArtifactLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.Artifact
  ) extends zio.aws.codepipeline.model.Artifact.ReadOnly {
    override val name: Optional[ArtifactName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codepipeline.model.primitives.ArtifactName(value))
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.codepipeline.model.primitives.Revision(value))
    override val location
        : Optional[zio.aws.codepipeline.model.ArtifactLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.codepipeline.model.ArtifactLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.Artifact
  ): zio.aws.codepipeline.model.Artifact.ReadOnly = new Wrapper(impl)
}
