package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codepipeline.model.primitives.{Timestamp, PipelineArn}
import scala.jdk.CollectionConverters._
final case class PipelineMetadata(
    pipelineArn: Optional[PipelineArn] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    updated: Optional[Timestamp] = Optional.Absent,
    pollingDisabledAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineMetadata = {
    import PipelineMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(updated.map(value => Timestamp.unwrap(value): Instant))(
        _.updated
      )
      .optionallyWith(
        pollingDisabledAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pollingDisabledAt)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineMetadata.ReadOnly =
    zio.aws.codepipeline.model.PipelineMetadata.wrap(buildAwsValue())
}
object PipelineMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineMetadata =
      zio.aws.codepipeline.model.PipelineMetadata(
        pipelineArn.map(value => value),
        created.map(value => value),
        updated.map(value => value),
        pollingDisabledAt.map(value => value)
      )
    def pipelineArn: Optional[PipelineArn]
    def created: Optional[Timestamp]
    def updated: Optional[Timestamp]
    def pollingDisabledAt: Optional[Timestamp]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updated", updated)
    def getPollingDisabledAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pollingDisabledAt", pollingDisabledAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
  ) extends zio.aws.codepipeline.model.PipelineMetadata.ReadOnly {
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineArn(value))
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val updated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updated())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val pollingDisabledAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.pollingDisabledAt())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineMetadata
  ): zio.aws.codepipeline.model.PipelineMetadata.ReadOnly = new Wrapper(impl)
}
