package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Version, ActionProvider}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCustomActionTypeRequest(
    category: zio.aws.codepipeline.model.ActionCategory,
    provider: ActionProvider,
    version: Version
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest = {
    import DeleteCustomActionTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest
      .builder()
      .category(category.unwrap)
      .provider(ActionProvider.unwrap(provider): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.DeleteCustomActionTypeRequest.ReadOnly =
    zio.aws.codepipeline.model.DeleteCustomActionTypeRequest
      .wrap(buildAwsValue())
}
object DeleteCustomActionTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.DeleteCustomActionTypeRequest =
      zio.aws.codepipeline.model
        .DeleteCustomActionTypeRequest(category, provider, version)
    def category: zio.aws.codepipeline.model.ActionCategory
    def provider: ActionProvider
    def version: Version
    def getCategory
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionCategory] =
      ZIO.succeed(category)
    def getProvider: ZIO[Any, Nothing, ActionProvider] = ZIO.succeed(provider)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest
  ) extends zio.aws.codepipeline.model.DeleteCustomActionTypeRequest.ReadOnly {
    override val category: zio.aws.codepipeline.model.ActionCategory =
      zio.aws.codepipeline.model.ActionCategory.wrap(impl.category())
    override val provider: ActionProvider =
      zio.aws.codepipeline.model.primitives.ActionProvider(impl.provider())
    override val version: Version =
      zio.aws.codepipeline.model.primitives.Version(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest
  ): zio.aws.codepipeline.model.DeleteCustomActionTypeRequest.ReadOnly =
    new Wrapper(impl)
}
