package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{MatchEquals, JsonPath}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WebhookFilterRule(
    jsonPath: JsonPath,
    matchEquals: Optional[MatchEquals] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.WebhookFilterRule = {
    import WebhookFilterRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.WebhookFilterRule
      .builder()
      .jsonPath(JsonPath.unwrap(jsonPath): java.lang.String)
      .optionallyWith(
        matchEquals.map(value => MatchEquals.unwrap(value): java.lang.String)
      )(_.matchEquals)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.WebhookFilterRule.ReadOnly =
    zio.aws.codepipeline.model.WebhookFilterRule.wrap(buildAwsValue())
}
object WebhookFilterRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.WebhookFilterRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.WebhookFilterRule =
      zio.aws.codepipeline.model
        .WebhookFilterRule(jsonPath, matchEquals.map(value => value))
    def jsonPath: JsonPath
    def matchEquals: Optional[MatchEquals]
    def getJsonPath: ZIO[Any, Nothing, JsonPath] = ZIO.succeed(jsonPath)
    def getMatchEquals: ZIO[Any, AwsError, MatchEquals] =
      AwsError.unwrapOptionField("matchEquals", matchEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.WebhookFilterRule
  ) extends zio.aws.codepipeline.model.WebhookFilterRule.ReadOnly {
    override val jsonPath: JsonPath =
      zio.aws.codepipeline.model.primitives.JsonPath(impl.jsonPath())
    override val matchEquals: Optional[MatchEquals] = zio.aws.core.internal
      .optionalFromNullable(impl.matchEquals())
      .map(value => zio.aws.codepipeline.model.primitives.MatchEquals(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.WebhookFilterRule
  ): zio.aws.codepipeline.model.WebhookFilterRule.ReadOnly = new Wrapper(impl)
}
