package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait ActionExecutionStatus {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus
}
object ActionExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus
  ): zio.aws.codepipeline.model.ActionExecutionStatus = value match {
    case software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.ABANDONED =>
      val r = Abandoned
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ActionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress
      extends zio.aws.codepipeline.model.ActionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.IN_PROGRESS
  }
  case object Abandoned
      extends zio.aws.codepipeline.model.ActionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.ABANDONED
  }
  case object Succeeded
      extends zio.aws.codepipeline.model.ActionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.codepipeline.model.ActionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus.FAILED
  }
}
