package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ArtifactLocation(
    `type`: Optional[zio.aws.codepipeline.model.ArtifactLocationType] =
      Optional.Absent,
    s3Location: Optional[zio.aws.codepipeline.model.S3ArtifactLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ArtifactLocation = {
    import ArtifactLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ArtifactLocation
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ArtifactLocation.ReadOnly =
    zio.aws.codepipeline.model.ArtifactLocation.wrap(buildAwsValue())
}
object ArtifactLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ArtifactLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ArtifactLocation =
      zio.aws.codepipeline.model.ArtifactLocation(
        `type`.map(value => value),
        s3Location.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.codepipeline.model.ArtifactLocationType]
    def s3Location
        : Optional[zio.aws.codepipeline.model.S3ArtifactLocation.ReadOnly]
    def getType
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ArtifactLocationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.S3ArtifactLocation.ReadOnly
    ] = AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactLocation
  ) extends zio.aws.codepipeline.model.ArtifactLocation.ReadOnly {
    override val `type`
        : Optional[zio.aws.codepipeline.model.ArtifactLocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.codepipeline.model.ArtifactLocationType.wrap(value)
        )
    override val s3Location
        : Optional[zio.aws.codepipeline.model.S3ArtifactLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.codepipeline.model.S3ArtifactLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactLocation
  ): zio.aws.codepipeline.model.ArtifactLocation.ReadOnly = new Wrapper(impl)
}
