package zio.aws.codepipeline
import zio.aws.codepipeline.model.primitives.{
  ActionConfigurationKey,
  ServicePrincipal,
  AccountId,
  OutputVariablesKey,
  ActionConfigurationValue,
  ActionConfigurationQueryableValue,
  AllowedAccount,
  AWSRegionName,
  TagKey,
  OutputVariablesValue
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.codepipeline.model.primitives.JsonPath.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AWSRegionName extends Subtype[String]
    type AWSRegionName =
      zio.aws.codepipeline.model.primitives.AWSRegionName.Type
    object AccessKeyId extends Subtype[String]
    type AccessKeyId = zio.aws.codepipeline.model.primitives.AccessKeyId.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.codepipeline.model.primitives.AccountId.Type
    object ActionConfigurationKey extends Subtype[String]
    type ActionConfigurationKey =
      zio.aws.codepipeline.model.primitives.ActionConfigurationKey.Type
    object ActionConfigurationQueryableValue extends Subtype[String]
    type ActionConfigurationQueryableValue =
      zio.aws.codepipeline.model.primitives.ActionConfigurationQueryableValue.Type
    object ActionConfigurationValue extends Subtype[String]
    type ActionConfigurationValue =
      zio.aws.codepipeline.model.primitives.ActionConfigurationValue.Type
    object ActionExecutionId extends Subtype[String]
    type ActionExecutionId =
      zio.aws.codepipeline.model.primitives.ActionExecutionId.Type
    object ActionExecutionToken extends Subtype[String]
    type ActionExecutionToken =
      zio.aws.codepipeline.model.primitives.ActionExecutionToken.Type
    object ActionName extends Subtype[String]
    type ActionName = zio.aws.codepipeline.model.primitives.ActionName.Type
    object ActionNamespace extends Subtype[String]
    type ActionNamespace =
      zio.aws.codepipeline.model.primitives.ActionNamespace.Type
    object ActionProvider extends Subtype[String]
    type ActionProvider =
      zio.aws.codepipeline.model.primitives.ActionProvider.Type
    object ActionRunOrder extends Subtype[Int]
    type ActionRunOrder =
      zio.aws.codepipeline.model.primitives.ActionRunOrder.Type
    object ActionTypeDescription extends Subtype[String]
    type ActionTypeDescription =
      zio.aws.codepipeline.model.primitives.ActionTypeDescription.Type
    object ActionTypeOwner extends Subtype[String]
    type ActionTypeOwner =
      zio.aws.codepipeline.model.primitives.ActionTypeOwner.Type
    object AllowedAccount extends Subtype[String]
    type AllowedAccount =
      zio.aws.codepipeline.model.primitives.AllowedAccount.Type
    object ApprovalSummary extends Subtype[String]
    type ApprovalSummary =
      zio.aws.codepipeline.model.primitives.ApprovalSummary.Type
    object ApprovalToken extends Subtype[String]
    type ApprovalToken =
      zio.aws.codepipeline.model.primitives.ApprovalToken.Type
    object ArtifactName extends Subtype[String]
    type ArtifactName = zio.aws.codepipeline.model.primitives.ArtifactName.Type
    object ArtifactStoreLocation extends Subtype[String]
    type ArtifactStoreLocation =
      zio.aws.codepipeline.model.primitives.ArtifactStoreLocation.Type
    object BlockerName extends Subtype[String]
    type BlockerName = zio.aws.codepipeline.model.primitives.BlockerName.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.codepipeline.model.primitives.ClientId.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.codepipeline.model.primitives.ClientRequestToken.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.codepipeline.model.primitives.ClientToken.Type
    object Code extends Subtype[String]
    type Code = zio.aws.codepipeline.model.primitives.Code.Type
    object ContinuationToken extends Subtype[String]
    type ContinuationToken =
      zio.aws.codepipeline.model.primitives.ContinuationToken.Type
    object Description extends Subtype[String]
    type Description = zio.aws.codepipeline.model.primitives.Description.Type
    object DisabledReason extends Subtype[String]
    type DisabledReason =
      zio.aws.codepipeline.model.primitives.DisabledReason.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.codepipeline.model.primitives.Enabled.Type
    object EncryptionKeyId extends Subtype[String]
    type EncryptionKeyId =
      zio.aws.codepipeline.model.primitives.EncryptionKeyId.Type
    object ExecutionId extends Subtype[String]
    type ExecutionId = zio.aws.codepipeline.model.primitives.ExecutionId.Type
    object ExecutionSummary extends Subtype[String]
    type ExecutionSummary =
      zio.aws.codepipeline.model.primitives.ExecutionSummary.Type
    object ExternalExecutionId extends Subtype[String]
    type ExternalExecutionId =
      zio.aws.codepipeline.model.primitives.ExternalExecutionId.Type
    object ExternalExecutionSummary extends Subtype[String]
    type ExternalExecutionSummary =
      zio.aws.codepipeline.model.primitives.ExternalExecutionSummary.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.codepipeline.model.primitives.JobId.Type
    object JobTimeout extends Subtype[Int]
    type JobTimeout = zio.aws.codepipeline.model.primitives.JobTimeout.Type
    object JsonPath extends Subtype[String]
    type JsonPath = zio.aws.codepipeline.model.primitives.JsonPath.Type
    object LambdaFunctionArn extends Subtype[String]
    type LambdaFunctionArn =
      zio.aws.codepipeline.model.primitives.LambdaFunctionArn.Type
    object LastChangedAt extends Subtype[Instant]
    type LastChangedAt =
      zio.aws.codepipeline.model.primitives.LastChangedAt.Type
    object LastChangedBy extends Subtype[String]
    type LastChangedBy =
      zio.aws.codepipeline.model.primitives.LastChangedBy.Type
    object LastUpdatedBy extends Subtype[String]
    type LastUpdatedBy =
      zio.aws.codepipeline.model.primitives.LastUpdatedBy.Type
    object MatchEquals extends Subtype[String]
    type MatchEquals = zio.aws.codepipeline.model.primitives.MatchEquals.Type
    object MaxBatchSize extends Subtype[Int]
    type MaxBatchSize = zio.aws.codepipeline.model.primitives.MaxBatchSize.Type
    object MaxPipelines extends Subtype[Int]
    type MaxPipelines = zio.aws.codepipeline.model.primitives.MaxPipelines.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.codepipeline.model.primitives.MaxResults.Type
    object MaximumActionTypeArtifactCount extends Subtype[Int]
    type MaximumActionTypeArtifactCount =
      zio.aws.codepipeline.model.primitives.MaximumActionTypeArtifactCount.Type
    object MaximumArtifactCount extends Subtype[Int]
    type MaximumArtifactCount =
      zio.aws.codepipeline.model.primitives.MaximumArtifactCount.Type
    object Message extends Subtype[String]
    type Message = zio.aws.codepipeline.model.primitives.Message.Type
    object MinimumActionTypeArtifactCount extends Subtype[Int]
    type MinimumActionTypeArtifactCount =
      zio.aws.codepipeline.model.primitives.MinimumActionTypeArtifactCount.Type
    object MinimumArtifactCount extends Subtype[Int]
    type MinimumArtifactCount =
      zio.aws.codepipeline.model.primitives.MinimumArtifactCount.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.codepipeline.model.primitives.NextToken.Type
    object Nonce extends Subtype[String]
    type Nonce = zio.aws.codepipeline.model.primitives.Nonce.Type
    object OutputVariablesKey extends Subtype[String]
    type OutputVariablesKey =
      zio.aws.codepipeline.model.primitives.OutputVariablesKey.Type
    object OutputVariablesValue extends Subtype[String]
    type OutputVariablesValue =
      zio.aws.codepipeline.model.primitives.OutputVariablesValue.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.codepipeline.model.primitives.Percentage.Type
    object PipelineArn extends Subtype[String]
    type PipelineArn = zio.aws.codepipeline.model.primitives.PipelineArn.Type
    object PipelineExecutionId extends Subtype[String]
    type PipelineExecutionId =
      zio.aws.codepipeline.model.primitives.PipelineExecutionId.Type
    object PipelineExecutionStatusSummary extends Subtype[String]
    type PipelineExecutionStatusSummary =
      zio.aws.codepipeline.model.primitives.PipelineExecutionStatusSummary.Type
    object PipelineName extends Subtype[String]
    type PipelineName = zio.aws.codepipeline.model.primitives.PipelineName.Type
    object PipelineVersion extends Subtype[Int]
    type PipelineVersion =
      zio.aws.codepipeline.model.primitives.PipelineVersion.Type
    object PolicyStatementsTemplate extends Subtype[String]
    type PolicyStatementsTemplate =
      zio.aws.codepipeline.model.primitives.PolicyStatementsTemplate.Type
    object PropertyDescription extends Subtype[String]
    type PropertyDescription =
      zio.aws.codepipeline.model.primitives.PropertyDescription.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.codepipeline.model.primitives.ResourceArn.Type
    object Revision extends Subtype[String]
    type Revision = zio.aws.codepipeline.model.primitives.Revision.Type
    object RevisionChangeIdentifier extends Subtype[String]
    type RevisionChangeIdentifier =
      zio.aws.codepipeline.model.primitives.RevisionChangeIdentifier.Type
    object RevisionSummary extends Subtype[String]
    type RevisionSummary =
      zio.aws.codepipeline.model.primitives.RevisionSummary.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.codepipeline.model.primitives.RoleArn.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.codepipeline.model.primitives.S3Bucket.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.codepipeline.model.primitives.S3BucketName.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.codepipeline.model.primitives.S3Key.Type
    object S3ObjectKey extends Subtype[String]
    type S3ObjectKey = zio.aws.codepipeline.model.primitives.S3ObjectKey.Type
    object SecretAccessKey extends Subtype[String]
    type SecretAccessKey =
      zio.aws.codepipeline.model.primitives.SecretAccessKey.Type
    object ServicePrincipal extends Subtype[String]
    type ServicePrincipal =
      zio.aws.codepipeline.model.primitives.ServicePrincipal.Type
    object SessionToken extends Subtype[String]
    type SessionToken = zio.aws.codepipeline.model.primitives.SessionToken.Type
    object StageName extends Subtype[String]
    type StageName = zio.aws.codepipeline.model.primitives.StageName.Type
    object StopPipelineExecutionReason extends Subtype[String]
    type StopPipelineExecutionReason =
      zio.aws.codepipeline.model.primitives.StopPipelineExecutionReason.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.codepipeline.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.codepipeline.model.primitives.TagValue.Type
    object ThirdPartyJobId extends Subtype[String]
    type ThirdPartyJobId =
      zio.aws.codepipeline.model.primitives.ThirdPartyJobId.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.codepipeline.model.primitives.Time.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.codepipeline.model.primitives.Timestamp.Type
    object TriggerDetail extends Subtype[String]
    type TriggerDetail =
      zio.aws.codepipeline.model.primitives.TriggerDetail.Type
    object Url extends Subtype[String]
    type Url = zio.aws.codepipeline.model.primitives.Url.Type
    object UrlTemplate extends Subtype[String]
    type UrlTemplate = zio.aws.codepipeline.model.primitives.UrlTemplate.Type
    object Version extends Subtype[String]
    type Version = zio.aws.codepipeline.model.primitives.Version.Type
    object WebhookArn extends Subtype[String]
    type WebhookArn = zio.aws.codepipeline.model.primitives.WebhookArn.Type
    object WebhookAuthConfigurationAllowedIPRange extends Subtype[String]
    type WebhookAuthConfigurationAllowedIPRange =
      zio.aws.codepipeline.model.primitives.WebhookAuthConfigurationAllowedIPRange.Type
    object WebhookAuthConfigurationSecretToken extends Subtype[String]
    type WebhookAuthConfigurationSecretToken =
      zio.aws.codepipeline.model.primitives.WebhookAuthConfigurationSecretToken.Type
    object WebhookErrorCode extends Subtype[String]
    type WebhookErrorCode =
      zio.aws.codepipeline.model.primitives.WebhookErrorCode.Type
    object WebhookErrorMessage extends Subtype[String]
    type WebhookErrorMessage =
      zio.aws.codepipeline.model.primitives.WebhookErrorMessage.Type
    object WebhookLastTriggered extends Subtype[Instant]
    type WebhookLastTriggered =
      zio.aws.codepipeline.model.primitives.WebhookLastTriggered.Type
    object WebhookName extends Subtype[String]
    type WebhookName = zio.aws.codepipeline.model.primitives.WebhookName.Type
    object WebhookUrl extends Subtype[String]
    type WebhookUrl = zio.aws.codepipeline.model.primitives.WebhookUrl.Type
  }
  type ActionConfigurationMap =
    Map[ActionConfigurationKey, ActionConfigurationValue]
  type ActionConfigurationPropertyList =
    List[zio.aws.codepipeline.model.ActionConfigurationProperty]
  type ActionExecutionDetailList =
    List[zio.aws.codepipeline.model.ActionExecutionDetail]
  type ActionStateList = List[zio.aws.codepipeline.model.ActionState]
  type ActionTypeList = List[zio.aws.codepipeline.model.ActionType]
  type ActionTypeProperties =
    List[zio.aws.codepipeline.model.ActionTypeProperty]
  type AllowedAccounts = List[AllowedAccount]
  type ArtifactDetailList = List[zio.aws.codepipeline.model.ArtifactDetail]
  type ArtifactList = List[zio.aws.codepipeline.model.Artifact]
  type ArtifactRevisionList = List[zio.aws.codepipeline.model.ArtifactRevision]
  type ArtifactStoreMap =
    Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore]
  type InputArtifactList = List[zio.aws.codepipeline.model.InputArtifact]
  type JobList = List[zio.aws.codepipeline.model.Job]
  type OutputArtifactList = List[zio.aws.codepipeline.model.OutputArtifact]
  type OutputVariablesMap = Map[OutputVariablesKey, OutputVariablesValue]
  type PipelineExecutionSummaryList =
    List[zio.aws.codepipeline.model.PipelineExecutionSummary]
  type PipelineList = List[zio.aws.codepipeline.model.PipelineSummary]
  type PipelineStageDeclarationList =
    List[zio.aws.codepipeline.model.StageDeclaration]
  type PollingAccountList = List[AccountId]
  type PollingServicePrincipalList = List[ServicePrincipal]
  type QueryParamMap =
    Map[ActionConfigurationKey, ActionConfigurationQueryableValue]
  type ResolvedActionConfigurationMap = Map[String, String]
  type SourceRevisionList = List[zio.aws.codepipeline.model.SourceRevision]
  type StageActionDeclarationList =
    List[zio.aws.codepipeline.model.ActionDeclaration]
  type StageBlockerDeclarationList =
    List[zio.aws.codepipeline.model.BlockerDeclaration]
  type StageStateList = List[zio.aws.codepipeline.model.StageState]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.codepipeline.model.Tag]
  type ThirdPartyJobList = List[zio.aws.codepipeline.model.ThirdPartyJob]
  type WebhookFilters = List[zio.aws.codepipeline.model.WebhookFilterRule]
  type WebhookList = List[zio.aws.codepipeline.model.ListWebhookItem]
}
