package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecutorConfiguration(
    lambdaExecutorConfiguration: Optional[
      zio.aws.codepipeline.model.LambdaExecutorConfiguration
    ] = Optional.Absent,
    jobWorkerExecutorConfiguration: Optional[
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration = {
    import ExecutorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
      .builder()
      .optionallyWith(
        lambdaExecutorConfiguration.map(value => value.buildAwsValue())
      )(_.lambdaExecutorConfiguration)
      .optionallyWith(
        jobWorkerExecutorConfiguration.map(value => value.buildAwsValue())
      )(_.jobWorkerExecutorConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly =
    zio.aws.codepipeline.model.ExecutorConfiguration.wrap(buildAwsValue())
}
object ExecutorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ExecutorConfiguration =
      zio.aws.codepipeline.model.ExecutorConfiguration(
        lambdaExecutorConfiguration.map(value => value.asEditable),
        jobWorkerExecutorConfiguration.map(value => value.asEditable)
      )
    def lambdaExecutorConfiguration: Optional[
      zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly
    ]
    def jobWorkerExecutorConfiguration: Optional[
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly
    ]
    def getLambdaExecutorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaExecutorConfiguration",
      lambdaExecutorConfiguration
    )
    def getJobWorkerExecutorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobWorkerExecutorConfiguration",
      jobWorkerExecutorConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
  ) extends zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly {
    override val lambdaExecutorConfiguration: Optional[
      zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaExecutorConfiguration())
      .map(value =>
        zio.aws.codepipeline.model.LambdaExecutorConfiguration.wrap(value)
      )
    override val jobWorkerExecutorConfiguration: Optional[
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.jobWorkerExecutorConfiguration())
      .map(value =>
        zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
  ): zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
