package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPipelineStateRequest(name: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest = {
    import GetPipelineStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest
      .builder()
      .name(PipelineName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetPipelineStateRequest.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineStateRequest.wrap(buildAwsValue())
}
object GetPipelineStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineStateRequest =
      zio.aws.codepipeline.model.GetPipelineStateRequest(name)
    def name: PipelineName
    def getName: ZIO[Any, Nothing, PipelineName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest
  ) extends zio.aws.codepipeline.model.GetPipelineStateRequest.ReadOnly {
    override val name: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest
  ): zio.aws.codepipeline.model.GetPipelineStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
