package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ActionTypeDescription
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionTypeDeclaration(
    description: Optional[ActionTypeDescription] = Optional.Absent,
    executor: zio.aws.codepipeline.model.ActionTypeExecutor,
    id: zio.aws.codepipeline.model.ActionTypeIdentifier,
    inputArtifactDetails: zio.aws.codepipeline.model.ActionTypeArtifactDetails,
    outputArtifactDetails: zio.aws.codepipeline.model.ActionTypeArtifactDetails,
    permissions: Optional[zio.aws.codepipeline.model.ActionTypePermissions] =
      Optional.Absent,
    properties: Optional[
      Iterable[zio.aws.codepipeline.model.ActionTypeProperty]
    ] = Optional.Absent,
    urls: Optional[zio.aws.codepipeline.model.ActionTypeUrls] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeDeclaration = {
    import ActionTypeDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeDeclaration
      .builder()
      .optionallyWith(
        description.map(value =>
          ActionTypeDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .executor(executor.buildAwsValue())
      .id(id.buildAwsValue())
      .inputArtifactDetails(inputArtifactDetails.buildAwsValue())
      .outputArtifactDetails(outputArtifactDetails.buildAwsValue())
      .optionallyWith(permissions.map(value => value.buildAwsValue()))(
        _.permissions
      )
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .optionallyWith(urls.map(value => value.buildAwsValue()))(_.urls)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeDeclaration.wrap(buildAwsValue())
}
object ActionTypeDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeDeclaration =
      zio.aws.codepipeline.model.ActionTypeDeclaration(
        description.map(value => value),
        executor.asEditable,
        id.asEditable,
        inputArtifactDetails.asEditable,
        outputArtifactDetails.asEditable,
        permissions.map(value => value.asEditable),
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        urls.map(value => value.asEditable)
      )
    def description: Optional[ActionTypeDescription]
    def executor: zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly
    def id: zio.aws.codepipeline.model.ActionTypeIdentifier.ReadOnly
    def inputArtifactDetails
        : zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly
    def outputArtifactDetails
        : zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly
    def permissions
        : Optional[zio.aws.codepipeline.model.ActionTypePermissions.ReadOnly]
    def properties
        : Optional[List[zio.aws.codepipeline.model.ActionTypeProperty.ReadOnly]]
    def urls: Optional[zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly]
    def getDescription: ZIO[Any, AwsError, ActionTypeDescription] =
      AwsError.unwrapOptionField("description", description)
    def getExecutor: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly
    ] = ZIO.succeed(executor)
    def getId: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ActionTypeIdentifier.ReadOnly
    ] = ZIO.succeed(id)
    def getInputArtifactDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly
    ] = ZIO.succeed(inputArtifactDetails)
    def getOutputArtifactDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly
    ] = ZIO.succeed(outputArtifactDetails)
    def getPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionTypePermissions.ReadOnly
    ] = AwsError.unwrapOptionField("permissions", permissions)
    def getProperties: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ActionTypeProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
    def getUrls: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly
    ] = AwsError.unwrapOptionField("urls", urls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeDeclaration
  ) extends zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly {
    override val description: Optional[ActionTypeDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ActionTypeDescription(value)
        )
    override val executor
        : zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeExecutor.wrap(impl.executor())
    override val id: zio.aws.codepipeline.model.ActionTypeIdentifier.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeIdentifier.wrap(impl.id())
    override val inputArtifactDetails
        : zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeArtifactDetails
        .wrap(impl.inputArtifactDetails())
    override val outputArtifactDetails
        : zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeArtifactDetails
        .wrap(impl.outputArtifactDetails())
    override val permissions
        : Optional[zio.aws.codepipeline.model.ActionTypePermissions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          zio.aws.codepipeline.model.ActionTypePermissions.wrap(value)
        )
    override val properties: Optional[
      List[zio.aws.codepipeline.model.ActionTypeProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.ActionTypeProperty.wrap(item)
        }.toList
      )
    override val urls
        : Optional[zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.urls())
        .map(value => zio.aws.codepipeline.model.ActionTypeUrls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeDeclaration
  ): zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly = new Wrapper(
    impl
  )
}
