package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{StageName, PipelineName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableStageTransitionRequest(
    pipelineName: PipelineName,
    stageName: StageName,
    transitionType: zio.aws.codepipeline.model.StageTransitionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest = {
    import EnableStageTransitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .stageName(StageName.unwrap(stageName): java.lang.String)
      .transitionType(transitionType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.EnableStageTransitionRequest.ReadOnly =
    zio.aws.codepipeline.model.EnableStageTransitionRequest
      .wrap(buildAwsValue())
}
object EnableStageTransitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.EnableStageTransitionRequest =
      zio.aws.codepipeline.model
        .EnableStageTransitionRequest(pipelineName, stageName, transitionType)
    def pipelineName: PipelineName
    def stageName: StageName
    def transitionType: zio.aws.codepipeline.model.StageTransitionType
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStageName: ZIO[Any, Nothing, StageName] = ZIO.succeed(stageName)
    def getTransitionType
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.StageTransitionType] =
      ZIO.succeed(transitionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest
  ) extends zio.aws.codepipeline.model.EnableStageTransitionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val stageName: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.stageName())
    override val transitionType
        : zio.aws.codepipeline.model.StageTransitionType =
      zio.aws.codepipeline.model.StageTransitionType.wrap(impl.transitionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest
  ): zio.aws.codepipeline.model.EnableStageTransitionRequest.ReadOnly =
    new Wrapper(impl)
}
