package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdatePipelineRequest(
    pipeline: zio.aws.codepipeline.model.PipelineDeclaration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest = {
    import UpdatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest
      .builder()
      .pipeline(pipeline.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.UpdatePipelineRequest.ReadOnly =
    zio.aws.codepipeline.model.UpdatePipelineRequest.wrap(buildAwsValue())
}
object UpdatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.UpdatePipelineRequest =
      zio.aws.codepipeline.model.UpdatePipelineRequest(pipeline.asEditable)
    def pipeline: zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    def getPipeline: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    ] = ZIO.succeed(pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest
  ) extends zio.aws.codepipeline.model.UpdatePipelineRequest.ReadOnly {
    override val pipeline
        : zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly =
      zio.aws.codepipeline.model.PipelineDeclaration.wrap(impl.pipeline())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest
  ): zio.aws.codepipeline.model.UpdatePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
