package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ActionName,
  PipelineName,
  WebhookName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WebhookDefinition(
    name: WebhookName,
    targetPipeline: PipelineName,
    targetAction: ActionName,
    filters: Iterable[zio.aws.codepipeline.model.WebhookFilterRule],
    authentication: zio.aws.codepipeline.model.WebhookAuthenticationType,
    authenticationConfiguration: zio.aws.codepipeline.model.WebhookAuthConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.WebhookDefinition = {
    import WebhookDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.WebhookDefinition
      .builder()
      .name(WebhookName.unwrap(name): java.lang.String)
      .targetPipeline(PipelineName.unwrap(targetPipeline): java.lang.String)
      .targetAction(ActionName.unwrap(targetAction): java.lang.String)
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .authentication(authentication.unwrap)
      .authenticationConfiguration(authenticationConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.WebhookDefinition.ReadOnly =
    zio.aws.codepipeline.model.WebhookDefinition.wrap(buildAwsValue())
}
object WebhookDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.WebhookDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.WebhookDefinition =
      zio.aws.codepipeline.model.WebhookDefinition(
        name,
        targetPipeline,
        targetAction,
        filters.map { item =>
          item.asEditable
        },
        authentication,
        authenticationConfiguration.asEditable
      )
    def name: WebhookName
    def targetPipeline: PipelineName
    def targetAction: ActionName
    def filters: List[zio.aws.codepipeline.model.WebhookFilterRule.ReadOnly]
    def authentication: zio.aws.codepipeline.model.WebhookAuthenticationType
    def authenticationConfiguration
        : zio.aws.codepipeline.model.WebhookAuthConfiguration.ReadOnly
    def getName: ZIO[Any, Nothing, WebhookName] = ZIO.succeed(name)
    def getTargetPipeline: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(targetPipeline)
    def getTargetAction: ZIO[Any, Nothing, ActionName] =
      ZIO.succeed(targetAction)
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.WebhookFilterRule.ReadOnly
    ]] = ZIO.succeed(filters)
    def getAuthentication: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.WebhookAuthenticationType
    ] = ZIO.succeed(authentication)
    def getAuthenticationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.WebhookAuthConfiguration.ReadOnly
    ] = ZIO.succeed(authenticationConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.WebhookDefinition
  ) extends zio.aws.codepipeline.model.WebhookDefinition.ReadOnly {
    override val name: WebhookName =
      zio.aws.codepipeline.model.primitives.WebhookName(impl.name())
    override val targetPipeline: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.targetPipeline())
    override val targetAction: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.targetAction())
    override val filters
        : List[zio.aws.codepipeline.model.WebhookFilterRule.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.WebhookFilterRule.wrap(item)
      }
      .toList
    override val authentication
        : zio.aws.codepipeline.model.WebhookAuthenticationType =
      zio.aws.codepipeline.model.WebhookAuthenticationType
        .wrap(impl.authentication())
    override val authenticationConfiguration
        : zio.aws.codepipeline.model.WebhookAuthConfiguration.ReadOnly =
      zio.aws.codepipeline.model.WebhookAuthConfiguration
        .wrap(impl.authenticationConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.WebhookDefinition
  ): zio.aws.codepipeline.model.WebhookDefinition.ReadOnly = new Wrapper(impl)
}
