package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetJobDetailsRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest = {
    import GetJobDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetJobDetailsRequest.ReadOnly =
    zio.aws.codepipeline.model.GetJobDetailsRequest.wrap(buildAwsValue())
}
object GetJobDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetJobDetailsRequest =
      zio.aws.codepipeline.model.GetJobDetailsRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest
  ) extends zio.aws.codepipeline.model.GetJobDetailsRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.codepipeline.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest
  ): zio.aws.codepipeline.model.GetJobDetailsRequest.ReadOnly = new Wrapper(
    impl
  )
}
