package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListActionExecutionsResponse(
    actionExecutionDetails: Optional[
      Iterable[zio.aws.codepipeline.model.ActionExecutionDetail]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse = {
    import ListActionExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse
      .builder()
      .optionallyWith(
        actionExecutionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionExecutionDetails)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly =
    zio.aws.codepipeline.model.ListActionExecutionsResponse
      .wrap(buildAwsValue())
}
object ListActionExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListActionExecutionsResponse =
      zio.aws.codepipeline.model.ListActionExecutionsResponse(
        actionExecutionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def actionExecutionDetails: Optional[
      List[zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getActionExecutionDetails: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "actionExecutionDetails",
      actionExecutionDetails
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse
  ) extends zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly {
    override val actionExecutionDetails: Optional[
      List[zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.actionExecutionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.ActionExecutionDetail.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse
  ): zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
