package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetThirdPartyJobDetailsResponse(
    jobDetails: Optional[zio.aws.codepipeline.model.ThirdPartyJobDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse = {
    import GetThirdPartyJobDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
      .builder()
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly =
    zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse
      .wrap(buildAwsValue())
}
object GetThirdPartyJobDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse =
      zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse(
        jobDetails.map(value => value.asEditable)
      )
    def jobDetails
        : Optional[zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly]
    def getJobDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly
    ] = AwsError.unwrapOptionField("jobDetails", jobDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
  ) extends zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly {
    override val jobDetails
        : Optional[zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDetails())
        .map(value =>
          zio.aws.codepipeline.model.ThirdPartyJobDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
  ): zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
