package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  StopPipelineExecutionReason,
  PipelineExecutionId,
  PipelineName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopPipelineExecutionRequest(
    pipelineName: PipelineName,
    pipelineExecutionId: PipelineExecutionId,
    abandon: Optional[Boolean] = Optional.Absent,
    reason: Optional[StopPipelineExecutionReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest = {
    import StopPipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .optionallyWith(abandon.map(value => value: java.lang.Boolean))(_.abandon)
      .optionallyWith(
        reason.map(value =>
          StopPipelineExecutionReason.unwrap(value): java.lang.String
        )
      )(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.StopPipelineExecutionRequest.ReadOnly =
    zio.aws.codepipeline.model.StopPipelineExecutionRequest
      .wrap(buildAwsValue())
}
object StopPipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StopPipelineExecutionRequest =
      zio.aws.codepipeline.model.StopPipelineExecutionRequest(
        pipelineName,
        pipelineExecutionId,
        abandon.map(value => value),
        reason.map(value => value)
      )
    def pipelineName: PipelineName
    def pipelineExecutionId: PipelineExecutionId
    def abandon: Optional[Boolean]
    def reason: Optional[StopPipelineExecutionReason]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
    def getAbandon: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("abandon", abandon)
    def getReason: ZIO[Any, AwsError, StopPipelineExecutionReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest
  ) extends zio.aws.codepipeline.model.StopPipelineExecutionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
    override val abandon: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.abandon())
      .map(value => value: Boolean)
    override val reason: Optional[StopPipelineExecutionReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reason())
        .map(value =>
          zio.aws.codepipeline.model.primitives
            .StopPipelineExecutionReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest
  ): zio.aws.codepipeline.model.StopPipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
