package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWebhooksResponse(
    webhooks: Optional[Iterable[zio.aws.codepipeline.model.ListWebhookItem]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse = {
    import ListWebhooksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse
      .builder()
      .optionallyWith(
        webhooks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.webhooks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly =
    zio.aws.codepipeline.model.ListWebhooksResponse.wrap(buildAwsValue())
}
object ListWebhooksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListWebhooksResponse =
      zio.aws.codepipeline.model.ListWebhooksResponse(
        webhooks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def webhooks
        : Optional[List[zio.aws.codepipeline.model.ListWebhookItem.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getWebhooks: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ListWebhookItem.ReadOnly
    ]] = AwsError.unwrapOptionField("webhooks", webhooks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse
  ) extends zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly {
    override val webhooks
        : Optional[List[zio.aws.codepipeline.model.ListWebhookItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webhooks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ListWebhookItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse
  ): zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly = new Wrapper(
    impl
  )
}
