package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListWebhooksRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest = {
    import ListWebhooksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListWebhooksRequest.ReadOnly =
    zio.aws.codepipeline.model.ListWebhooksRequest.wrap(buildAwsValue())
}
object ListWebhooksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListWebhooksRequest =
      zio.aws.codepipeline.model.ListWebhooksRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest
  ) extends zio.aws.codepipeline.model.ListWebhooksRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codepipeline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest
  ): zio.aws.codepipeline.model.ListWebhooksRequest.ReadOnly = new Wrapper(impl)
}
