package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Nonce, ThirdPartyJobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ThirdPartyJobDetails(
    id: Option[ThirdPartyJobId] = None,
    data: Option[zio.aws.codepipeline.model.ThirdPartyJobData] = None,
    nonce: Option[Nonce] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails = {
    import ThirdPartyJobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
      .builder()
      .optionallyWith(
        id.map(value => ThirdPartyJobId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(data.map(value => value.buildAwsValue()))(_.data)
      .optionallyWith(
        nonce.map(value => Nonce.unwrap(value): java.lang.String)
      )(_.nonce)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly =
    zio.aws.codepipeline.model.ThirdPartyJobDetails.wrap(buildAwsValue())
}
object ThirdPartyJobDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ThirdPartyJobDetails =
      zio.aws.codepipeline.model.ThirdPartyJobDetails(
        id.map(value => value),
        data.map(value => value.asEditable),
        nonce.map(value => value)
      )
    def id: Option[ThirdPartyJobId]
    def data: Option[zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly]
    def nonce: Option[Nonce]
    def getId: ZIO[Any, AwsError, ThirdPartyJobId] =
      AwsError.unwrapOptionField("id", id)
    def getData: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly
    ] = AwsError.unwrapOptionField("data", data)
    def getNonce: ZIO[Any, AwsError, Nonce] =
      AwsError.unwrapOptionField("nonce", nonce)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
  ) extends zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly {
    override val id: Option[ThirdPartyJobId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ThirdPartyJobId(value)
      )
    override val data
        : Option[zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly] = scala
      .Option(impl.data())
      .map(value => zio.aws.codepipeline.model.ThirdPartyJobData.wrap(value))
    override val nonce: Option[Nonce] = scala
      .Option(impl.nonce())
      .map(value => zio.aws.codepipeline.model.primitives.Nonce(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
  ): zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly = new Wrapper(
    impl
  )
}
