package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ArtifactName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ArtifactDetail(
    name: Option[ArtifactName] = None,
    s3location: Option[zio.aws.codepipeline.model.S3Location] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ArtifactDetail = {
    import ArtifactDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ArtifactDetail
      .builder()
      .optionallyWith(
        name.map(value => ArtifactName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(s3location.map(value => value.buildAwsValue()))(
        _.s3location
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ArtifactDetail.ReadOnly =
    zio.aws.codepipeline.model.ArtifactDetail.wrap(buildAwsValue())
}
object ArtifactDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ArtifactDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ArtifactDetail =
      zio.aws.codepipeline.model.ArtifactDetail(
        name.map(value => value),
        s3location.map(value => value.asEditable)
      )
    def name: Option[ArtifactName]
    def s3location: Option[zio.aws.codepipeline.model.S3Location.ReadOnly]
    def getName: ZIO[Any, AwsError, ArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getS3location
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3location", s3location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactDetail
  ) extends zio.aws.codepipeline.model.ArtifactDetail.ReadOnly {
    override val name: Option[ArtifactName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codepipeline.model.primitives.ArtifactName(value))
    override val s3location
        : Option[zio.aws.codepipeline.model.S3Location.ReadOnly] = scala
      .Option(impl.s3location())
      .map(value => zio.aws.codepipeline.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactDetail
  ): zio.aws.codepipeline.model.ArtifactDetail.ReadOnly = new Wrapper(impl)
}
