package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PipelineExecutionStatusSummary,
  PipelineExecutionId,
  PipelineVersion,
  PipelineName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PipelineExecution(
    pipelineName: Option[PipelineName] = None,
    pipelineVersion: Option[PipelineVersion] = None,
    pipelineExecutionId: Option[PipelineExecutionId] = None,
    status: Option[zio.aws.codepipeline.model.PipelineExecutionStatus] = None,
    statusSummary: Option[PipelineExecutionStatusSummary] = None,
    artifactRevisions: Option[
      Iterable[zio.aws.codepipeline.model.ArtifactRevision]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineExecution = {
    import PipelineExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineExecution
      .builder()
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineVersion.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.pipelineVersion)
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusSummary.map(value =>
          PipelineExecutionStatusSummary.unwrap(value): java.lang.String
        )
      )(_.statusSummary)
      .optionallyWith(
        artifactRevisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifactRevisions)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineExecution.ReadOnly =
    zio.aws.codepipeline.model.PipelineExecution.wrap(buildAwsValue())
}
object PipelineExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineExecution =
      zio.aws.codepipeline.model.PipelineExecution(
        pipelineName.map(value => value),
        pipelineVersion.map(value => value),
        pipelineExecutionId.map(value => value),
        status.map(value => value),
        statusSummary.map(value => value),
        artifactRevisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineName: Option[PipelineName]
    def pipelineVersion: Option[PipelineVersion]
    def pipelineExecutionId: Option[PipelineExecutionId]
    def status: Option[zio.aws.codepipeline.model.PipelineExecutionStatus]
    def statusSummary: Option[PipelineExecutionStatusSummary]
    def artifactRevisions
        : Option[List[zio.aws.codepipeline.model.ArtifactRevision.ReadOnly]]
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("pipelineVersion", pipelineVersion)
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusSummary: ZIO[Any, AwsError, PipelineExecutionStatusSummary] =
      AwsError.unwrapOptionField("statusSummary", statusSummary)
    def getArtifactRevisions: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ArtifactRevision.ReadOnly
    ]] = AwsError.unwrapOptionField("artifactRevisions", artifactRevisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecution
  ) extends zio.aws.codepipeline.model.PipelineExecution.ReadOnly {
    override val pipelineName: Option[PipelineName] = scala
      .Option(impl.pipelineName())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineName(value))
    override val pipelineVersion: Option[PipelineVersion] = scala
      .Option(impl.pipelineVersion())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
    override val pipelineExecutionId: Option[PipelineExecutionId] = scala
      .Option(impl.pipelineExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
      )
    override val status
        : Option[zio.aws.codepipeline.model.PipelineExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.codepipeline.model.PipelineExecutionStatus.wrap(value)
      )
    override val statusSummary: Option[PipelineExecutionStatusSummary] = scala
      .Option(impl.statusSummary())
      .map(value =>
        zio.aws.codepipeline.model.primitives
          .PipelineExecutionStatusSummary(value)
      )
    override val artifactRevisions
        : Option[List[zio.aws.codepipeline.model.ArtifactRevision.ReadOnly]] =
      scala
        .Option(impl.artifactRevisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ArtifactRevision.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecution
  ): zio.aws.codepipeline.model.PipelineExecution.ReadOnly = new Wrapper(impl)
}
