package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ContinuationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobData(
    actionTypeId: Option[zio.aws.codepipeline.model.ActionTypeId] = None,
    actionConfiguration: Option[
      zio.aws.codepipeline.model.ActionConfiguration
    ] = None,
    pipelineContext: Option[zio.aws.codepipeline.model.PipelineContext] = None,
    inputArtifacts: Option[Iterable[zio.aws.codepipeline.model.Artifact]] =
      None,
    outputArtifacts: Option[Iterable[zio.aws.codepipeline.model.Artifact]] =
      None,
    artifactCredentials: Option[
      zio.aws.codepipeline.model.AWSSessionCredentials
    ] = None,
    continuationToken: Option[ContinuationToken] = None,
    encryptionKey: Option[zio.aws.codepipeline.model.EncryptionKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.JobData = {
    import JobData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.JobData
      .builder()
      .optionallyWith(actionTypeId.map(value => value.buildAwsValue()))(
        _.actionTypeId
      )
      .optionallyWith(actionConfiguration.map(value => value.buildAwsValue()))(
        _.actionConfiguration
      )
      .optionallyWith(pipelineContext.map(value => value.buildAwsValue()))(
        _.pipelineContext
      )
      .optionallyWith(
        inputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputArtifacts)
      .optionallyWith(
        outputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputArtifacts)
      .optionallyWith(artifactCredentials.map(value => value.buildAwsValue()))(
        _.artifactCredentials
      )
      .optionallyWith(
        continuationToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.continuationToken)
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.JobData.ReadOnly =
    zio.aws.codepipeline.model.JobData.wrap(buildAwsValue())
}
object JobData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.JobData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.JobData =
      zio.aws.codepipeline.model.JobData(
        actionTypeId.map(value => value.asEditable),
        actionConfiguration.map(value => value.asEditable),
        pipelineContext.map(value => value.asEditable),
        inputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifactCredentials.map(value => value.asEditable),
        continuationToken.map(value => value),
        encryptionKey.map(value => value.asEditable)
      )
    def actionTypeId: Option[zio.aws.codepipeline.model.ActionTypeId.ReadOnly]
    def actionConfiguration
        : Option[zio.aws.codepipeline.model.ActionConfiguration.ReadOnly]
    def pipelineContext
        : Option[zio.aws.codepipeline.model.PipelineContext.ReadOnly]
    def inputArtifacts
        : Option[List[zio.aws.codepipeline.model.Artifact.ReadOnly]]
    def outputArtifacts
        : Option[List[zio.aws.codepipeline.model.Artifact.ReadOnly]]
    def artifactCredentials
        : Option[zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly]
    def continuationToken: Option[ContinuationToken]
    def encryptionKey: Option[zio.aws.codepipeline.model.EncryptionKey.ReadOnly]
    def getActionTypeId
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      AwsError.unwrapOptionField("actionTypeId", actionTypeId)
    def getActionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("actionConfiguration", actionConfiguration)
    def getPipelineContext: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineContext.ReadOnly
    ] = AwsError.unwrapOptionField("pipelineContext", pipelineContext)
    def getInputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.Artifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getOutputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.Artifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getArtifactCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("artifactCredentials", artifactCredentials)
    def getContinuationToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getEncryptionKey: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.EncryptionKey.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionKey", encryptionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.JobData
  ) extends zio.aws.codepipeline.model.JobData.ReadOnly {
    override val actionTypeId
        : Option[zio.aws.codepipeline.model.ActionTypeId.ReadOnly] = scala
      .Option(impl.actionTypeId())
      .map(value => zio.aws.codepipeline.model.ActionTypeId.wrap(value))
    override val actionConfiguration
        : Option[zio.aws.codepipeline.model.ActionConfiguration.ReadOnly] =
      scala
        .Option(impl.actionConfiguration())
        .map(value =>
          zio.aws.codepipeline.model.ActionConfiguration.wrap(value)
        )
    override val pipelineContext
        : Option[zio.aws.codepipeline.model.PipelineContext.ReadOnly] = scala
      .Option(impl.pipelineContext())
      .map(value => zio.aws.codepipeline.model.PipelineContext.wrap(value))
    override val inputArtifacts
        : Option[List[zio.aws.codepipeline.model.Artifact.ReadOnly]] = scala
      .Option(impl.inputArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.Artifact.wrap(item)
        }.toList
      )
    override val outputArtifacts
        : Option[List[zio.aws.codepipeline.model.Artifact.ReadOnly]] = scala
      .Option(impl.outputArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.Artifact.wrap(item)
        }.toList
      )
    override val artifactCredentials
        : Option[zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly] =
      scala
        .Option(impl.artifactCredentials())
        .map(value =>
          zio.aws.codepipeline.model.AWSSessionCredentials.wrap(value)
        )
    override val continuationToken: Option[ContinuationToken] = scala
      .Option(impl.continuationToken())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ContinuationToken(value)
      )
    override val encryptionKey
        : Option[zio.aws.codepipeline.model.EncryptionKey.ReadOnly] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.codepipeline.model.EncryptionKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.JobData
  ): zio.aws.codepipeline.model.JobData.ReadOnly = new Wrapper(impl)
}
