package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActionType(
    id: zio.aws.codepipeline.model.ActionTypeId,
    settings: Option[zio.aws.codepipeline.model.ActionTypeSettings] = None,
    actionConfigurationProperties: Option[
      Iterable[zio.aws.codepipeline.model.ActionConfigurationProperty]
    ] = None,
    inputArtifactDetails: zio.aws.codepipeline.model.ArtifactDetails,
    outputArtifactDetails: zio.aws.codepipeline.model.ArtifactDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionType = {
    import ActionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionType
      .builder()
      .id(id.buildAwsValue())
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(
        actionConfigurationProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionConfigurationProperties)
      .inputArtifactDetails(inputArtifactDetails.buildAwsValue())
      .outputArtifactDetails(outputArtifactDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionType.ReadOnly =
    zio.aws.codepipeline.model.ActionType.wrap(buildAwsValue())
}
object ActionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionType =
      zio.aws.codepipeline.model.ActionType(
        id.asEditable,
        settings.map(value => value.asEditable),
        actionConfigurationProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputArtifactDetails.asEditable,
        outputArtifactDetails.asEditable
      )
    def id: zio.aws.codepipeline.model.ActionTypeId.ReadOnly
    def settings: Option[zio.aws.codepipeline.model.ActionTypeSettings.ReadOnly]
    def actionConfigurationProperties: Option[
      List[zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly]
    ]
    def inputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    def outputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    def getId
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      ZIO.succeed(id)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionTypeSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getActionConfigurationProperties: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "actionConfigurationProperties",
      actionConfigurationProperties
    )
    def getInputArtifactDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    ] = ZIO.succeed(inputArtifactDetails)
    def getOutputArtifactDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    ] = ZIO.succeed(outputArtifactDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionType
  ) extends zio.aws.codepipeline.model.ActionType.ReadOnly {
    override val id: zio.aws.codepipeline.model.ActionTypeId.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeId.wrap(impl.id())
    override val settings
        : Option[zio.aws.codepipeline.model.ActionTypeSettings.ReadOnly] = scala
      .Option(impl.settings())
      .map(value => zio.aws.codepipeline.model.ActionTypeSettings.wrap(value))
    override val actionConfigurationProperties: Option[
      List[zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly]
    ] = scala
      .Option(impl.actionConfigurationProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.ActionConfigurationProperty.wrap(item)
        }.toList
      )
    override val inputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly =
      zio.aws.codepipeline.model.ArtifactDetails
        .wrap(impl.inputArtifactDetails())
    override val outputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly =
      zio.aws.codepipeline.model.ArtifactDetails
        .wrap(impl.outputArtifactDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionType
  ): zio.aws.codepipeline.model.ActionType.ReadOnly = new Wrapper(impl)
}
