package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StageName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StageContext(name: Option[StageName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageContext = {
    import StageContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageContext
      .builder()
      .optionallyWith(
        name.map(value => StageName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageContext.ReadOnly =
    zio.aws.codepipeline.model.StageContext.wrap(buildAwsValue())
}
object StageContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageContext =
      zio.aws.codepipeline.model.StageContext(name.map(value => value))
    def name: Option[StageName]
    def getName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageContext
  ) extends zio.aws.codepipeline.model.StageContext.ReadOnly {
    override val name: Option[StageName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codepipeline.model.primitives.StageName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageContext
  ): zio.aws.codepipeline.model.StageContext.ReadOnly = new Wrapper(impl)
}
