package zio.aws.codepipeline.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  Timestamp,
  PipelineVersion,
  PipelineName
}
import scala.jdk.CollectionConverters._
final case class PipelineSummary(
    name: Option[PipelineName] = None,
    version: Option[PipelineVersion] = None,
    created: Option[Timestamp] = None,
    updated: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineSummary = {
    import PipelineSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineSummary
      .builder()
      .optionallyWith(
        name.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.version)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(updated.map(value => Timestamp.unwrap(value): Instant))(
        _.updated
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineSummary.ReadOnly =
    zio.aws.codepipeline.model.PipelineSummary.wrap(buildAwsValue())
}
object PipelineSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineSummary =
      zio.aws.codepipeline.model.PipelineSummary(
        name.map(value => value),
        version.map(value => value),
        created.map(value => value),
        updated.map(value => value)
      )
    def name: Option[PipelineName]
    def version: Option[PipelineVersion]
    def created: Option[Timestamp]
    def updated: Option[Timestamp]
    def getName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("version", version)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updated", updated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineSummary
  ) extends zio.aws.codepipeline.model.PipelineSummary.ReadOnly {
    override val name: Option[PipelineName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineName(value))
    override val version: Option[PipelineVersion] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
    override val created: Option[Timestamp] = scala
      .Option(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val updated: Option[Timestamp] = scala
      .Option(impl.updated())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineSummary
  ): zio.aws.codepipeline.model.PipelineSummary.ReadOnly = new Wrapper(impl)
}
