package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  NextToken,
  MaxResults,
  PipelineName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPipelineExecutionsRequest(
    pipelineName: PipelineName,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest = {
    import ListPipelineExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ListPipelineExecutionsRequest.ReadOnly =
    zio.aws.codepipeline.model.ListPipelineExecutionsRequest
      .wrap(buildAwsValue())
}
object ListPipelineExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListPipelineExecutionsRequest =
      zio.aws.codepipeline.model.ListPipelineExecutionsRequest(
        pipelineName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def pipelineName: PipelineName
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest
  ) extends zio.aws.codepipeline.model.ListPipelineExecutionsRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codepipeline.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest
  ): zio.aws.codepipeline.model.ListPipelineExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
