package zio.aws.codepipeline.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  PipelineVersion,
  ActionName,
  Timestamp,
  ActionExecutionId,
  PipelineExecutionId,
  StageName
}
import scala.jdk.CollectionConverters._
final case class ActionExecutionDetail(
    pipelineExecutionId: Option[PipelineExecutionId] = None,
    actionExecutionId: Option[ActionExecutionId] = None,
    pipelineVersion: Option[PipelineVersion] = None,
    stageName: Option[StageName] = None,
    actionName: Option[ActionName] = None,
    startTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None,
    status: Option[zio.aws.codepipeline.model.ActionExecutionStatus] = None,
    input: Option[zio.aws.codepipeline.model.ActionExecutionInput] = None,
    output: Option[zio.aws.codepipeline.model.ActionExecutionOutput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail = {
    import ActionExecutionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .optionallyWith(
        actionExecutionId.map(value =>
          ActionExecutionId.unwrap(value): java.lang.String
        )
      )(_.actionExecutionId)
      .optionallyWith(
        pipelineVersion.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.pipelineVersion)
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        actionName.map(value => ActionName.unwrap(value): java.lang.String)
      )(_.actionName)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .optionallyWith(output.map(value => value.buildAwsValue()))(_.output)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly =
    zio.aws.codepipeline.model.ActionExecutionDetail.wrap(buildAwsValue())
}
object ActionExecutionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionExecutionDetail =
      zio.aws.codepipeline.model.ActionExecutionDetail(
        pipelineExecutionId.map(value => value),
        actionExecutionId.map(value => value),
        pipelineVersion.map(value => value),
        stageName.map(value => value),
        actionName.map(value => value),
        startTime.map(value => value),
        lastUpdateTime.map(value => value),
        status.map(value => value),
        input.map(value => value.asEditable),
        output.map(value => value.asEditable)
      )
    def pipelineExecutionId: Option[PipelineExecutionId]
    def actionExecutionId: Option[ActionExecutionId]
    def pipelineVersion: Option[PipelineVersion]
    def stageName: Option[StageName]
    def actionName: Option[ActionName]
    def startTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def status: Option[zio.aws.codepipeline.model.ActionExecutionStatus]
    def input: Option[zio.aws.codepipeline.model.ActionExecutionInput.ReadOnly]
    def output
        : Option[zio.aws.codepipeline.model.ActionExecutionOutput.ReadOnly]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
    def getActionExecutionId: ZIO[Any, AwsError, ActionExecutionId] =
      AwsError.unwrapOptionField("actionExecutionId", actionExecutionId)
    def getPipelineVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("pipelineVersion", pipelineVersion)
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getActionName: ZIO[Any, AwsError, ActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInput: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionExecutionInput.ReadOnly
    ] = AwsError.unwrapOptionField("input", input)
    def getOutput: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionExecutionOutput.ReadOnly
    ] = AwsError.unwrapOptionField("output", output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail
  ) extends zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly {
    override val pipelineExecutionId: Option[PipelineExecutionId] = scala
      .Option(impl.pipelineExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
      )
    override val actionExecutionId: Option[ActionExecutionId] = scala
      .Option(impl.actionExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ActionExecutionId(value)
      )
    override val pipelineVersion: Option[PipelineVersion] = scala
      .Option(impl.pipelineVersion())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
    override val stageName: Option[StageName] = scala
      .Option(impl.stageName())
      .map(value => zio.aws.codepipeline.model.primitives.StageName(value))
    override val actionName: Option[ActionName] = scala
      .Option(impl.actionName())
      .map(value => zio.aws.codepipeline.model.primitives.ActionName(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val status
        : Option[zio.aws.codepipeline.model.ActionExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.codepipeline.model.ActionExecutionStatus.wrap(value)
      )
    override val input
        : Option[zio.aws.codepipeline.model.ActionExecutionInput.ReadOnly] =
      scala
        .Option(impl.input())
        .map(value =>
          zio.aws.codepipeline.model.ActionExecutionInput.wrap(value)
        )
    override val output
        : Option[zio.aws.codepipeline.model.ActionExecutionOutput.ReadOnly] =
      scala
        .Option(impl.output())
        .map(value =>
          zio.aws.codepipeline.model.ActionExecutionOutput.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail
  ): zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly = new Wrapper(
    impl
  )
}
