package zio.aws.codepipeline.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  Timestamp,
  PipelineVersion,
  PipelineName
}
import scala.jdk.CollectionConverters._
final case class GetPipelineStateResponse(
    pipelineName: Option[PipelineName] = None,
    pipelineVersion: Option[PipelineVersion] = None,
    stageStates: Option[Iterable[zio.aws.codepipeline.model.StageState]] = None,
    created: Option[Timestamp] = None,
    updated: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse = {
    import GetPipelineStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
      .builder()
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineVersion.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.pipelineVersion)
      .optionallyWith(
        stageStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stageStates)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(updated.map(value => Timestamp.unwrap(value): Instant))(
        _.updated
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineStateResponse.wrap(buildAwsValue())
}
object GetPipelineStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineStateResponse =
      zio.aws.codepipeline.model.GetPipelineStateResponse(
        pipelineName.map(value => value),
        pipelineVersion.map(value => value),
        stageStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        created.map(value => value),
        updated.map(value => value)
      )
    def pipelineName: Option[PipelineName]
    def pipelineVersion: Option[PipelineVersion]
    def stageStates
        : Option[List[zio.aws.codepipeline.model.StageState.ReadOnly]]
    def created: Option[Timestamp]
    def updated: Option[Timestamp]
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("pipelineVersion", pipelineVersion)
    def getStageStates: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.StageState.ReadOnly
    ]] = AwsError.unwrapOptionField("stageStates", stageStates)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updated", updated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
  ) extends zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly {
    override val pipelineName: Option[PipelineName] = scala
      .Option(impl.pipelineName())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineName(value))
    override val pipelineVersion: Option[PipelineVersion] = scala
      .Option(impl.pipelineVersion())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
    override val stageStates
        : Option[List[zio.aws.codepipeline.model.StageState.ReadOnly]] = scala
      .Option(impl.stageStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.StageState.wrap(item)
        }.toList
      )
    override val created: Option[Timestamp] = scala
      .Option(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val updated: Option[Timestamp] = scala
      .Option(impl.updated())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
  ): zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly = new Wrapper(
    impl
  )
}
