package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPipelineResponse(
    pipeline: Option[zio.aws.codepipeline.model.PipelineDeclaration] = None,
    metadata: Option[zio.aws.codepipeline.model.PipelineMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse = {
    import GetPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineResponse.wrap(buildAwsValue())
}
object GetPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineResponse =
      zio.aws.codepipeline.model.GetPipelineResponse(
        pipeline.map(value => value.asEditable),
        metadata.map(value => value.asEditable)
      )
    def pipeline
        : Option[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly]
    def metadata: Option[zio.aws.codepipeline.model.PipelineMetadata.ReadOnly]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
  ) extends zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly {
    override val pipeline
        : Option[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly] =
      scala
        .Option(impl.pipeline())
        .map(value =>
          zio.aws.codepipeline.model.PipelineDeclaration.wrap(value)
        )
    override val metadata
        : Option[zio.aws.codepipeline.model.PipelineMetadata.ReadOnly] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.codepipeline.model.PipelineMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse
  ): zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly = new Wrapper(impl)
}
