package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{ExecutionId, Message}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FailureDetails(
    `type`: zio.aws.codepipeline.model.FailureType,
    message: Message,
    externalExecutionId: Option[ExecutionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.FailureDetails = {
    import FailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.FailureDetails
      .builder()
      .`type`(`type`.unwrap)
      .message(Message.unwrap(message): java.lang.String)
      .optionallyWith(
        externalExecutionId.map(value =>
          ExecutionId.unwrap(value): java.lang.String
        )
      )(_.externalExecutionId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.FailureDetails.ReadOnly =
    zio.aws.codepipeline.model.FailureDetails.wrap(buildAwsValue())
}
object FailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.FailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.FailureDetails =
      zio.aws.codepipeline.model.FailureDetails(
        `type`,
        message,
        externalExecutionId.map(value => value)
      )
    def `type`: zio.aws.codepipeline.model.FailureType
    def message: Message
    def externalExecutionId: Option[ExecutionId]
    def getType: ZIO[Any, Nothing, zio.aws.codepipeline.model.FailureType] =
      ZIO.succeed(`type`)
    def getMessage: ZIO[Any, Nothing, Message] = ZIO.succeed(message)
    def getExternalExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("externalExecutionId", externalExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.FailureDetails
  ) extends zio.aws.codepipeline.model.FailureDetails.ReadOnly {
    override val `type`: zio.aws.codepipeline.model.FailureType =
      zio.aws.codepipeline.model.FailureType.wrap(impl.`type`())
    override val message: Message =
      zio.aws.codepipeline.model.primitives.Message(impl.message())
    override val externalExecutionId: Option[ExecutionId] = scala
      .Option(impl.externalExecutionId())
      .map(value => zio.aws.codepipeline.model.primitives.ExecutionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.FailureDetails
  ): zio.aws.codepipeline.model.FailureDetails.ReadOnly = new Wrapper(impl)
}
